/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.event;

import com.facebook.airlift.event.client.EventField;
import com.facebook.airlift.event.client.EventType;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.verifier.prestoaction.QueryActionStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;

@EventType(value="QueryInfo")
@Immutable
public class QueryInfo {
    private final String catalog;
    private final String schema;
    private final String originalQuery;
    private final Map<String, String> sessionProperties;
    private final String queryId;
    private final List<String> setupQueryIds;
    private final List<String> teardownQueryIds;
    private final String checksumQueryId;
    private final String query;
    private final List<String> setupQueries;
    private final List<String> teardownQueries;
    private final String checksumQuery;
    private final String jsonPlan;
    private final String outputTableName;
    private final Double cpuTimeSecs;
    private final Double wallTimeSecs;
    private final Long peakTotalMemoryBytes;
    private final Long peakTaskTotalMemoryBytes;
    private final String extraStats;

    public QueryInfo(String catalog, String schema, String originalQuery, Map<String, String> sessionProperties, List<String> setupQueryIds, List<String> teardownQueryIds, Optional<String> checksumQueryId, Optional<String> query, Optional<List<String>> setupQueries, Optional<List<String>> teardownQueries, Optional<String> checksumQuery, Optional<String> jsonPlan, Optional<QueryActionStats> queryActionStats, Optional<String> outputTableName) {
        Optional<Object> stats = queryActionStats.flatMap(QueryActionStats::getQueryStats);
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.originalQuery = Objects.requireNonNull(originalQuery, "originalQuery is null");
        this.sessionProperties = ImmutableMap.copyOf(sessionProperties);
        this.queryId = stats.map(QueryStats::getQueryId).orElse(null);
        this.setupQueryIds = ImmutableList.copyOf(setupQueryIds);
        this.teardownQueryIds = ImmutableList.copyOf(teardownQueryIds);
        this.checksumQueryId = checksumQueryId.orElse(null);
        this.query = query.orElse(null);
        this.setupQueries = setupQueries.orElse(null);
        this.teardownQueries = teardownQueries.orElse(null);
        this.checksumQuery = checksumQuery.orElse(null);
        this.jsonPlan = jsonPlan.orElse(null);
        this.cpuTimeSecs = stats.map(QueryStats::getCpuTimeMillis).map(QueryInfo::millisToSeconds).orElse(null);
        this.wallTimeSecs = stats.map(QueryStats::getWallTimeMillis).map(QueryInfo::millisToSeconds).orElse(null);
        this.peakTotalMemoryBytes = stats.map(QueryStats::getPeakTotalMemoryBytes).orElse(null);
        this.peakTaskTotalMemoryBytes = stats.map(QueryStats::getPeakTaskTotalMemoryBytes).orElse(null);
        this.extraStats = queryActionStats.flatMap(QueryActionStats::getExtraStats).orElse(null);
        this.outputTableName = outputTableName.orElse(null);
    }

    private static double millisToSeconds(long millis) {
        return new Duration((double)millis, TimeUnit.MILLISECONDS).getValue(TimeUnit.SECONDS);
    }

    @EventField
    public String getCatalog() {
        return this.catalog;
    }

    @EventField
    public String getSchema() {
        return this.schema;
    }

    @EventField
    public String getOriginalQuery() {
        return this.originalQuery;
    }

    @EventField
    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    @EventField
    public String getQueryId() {
        return this.queryId;
    }

    @EventField
    public List<String> getSetupQueryIds() {
        return this.setupQueryIds;
    }

    @EventField
    public List<String> getTeardownQueryIds() {
        return this.teardownQueryIds;
    }

    @EventField
    public String getChecksumQueryId() {
        return this.checksumQueryId;
    }

    @EventField
    public String getQuery() {
        return this.query;
    }

    @EventField
    public List<String> getSetupQueries() {
        return this.setupQueries;
    }

    @EventField
    public List<String> getTeardownQueries() {
        return this.teardownQueries;
    }

    @EventField
    public String getChecksumQuery() {
        return this.checksumQuery;
    }

    @EventField
    public String getJsonPlan() {
        return this.jsonPlan;
    }

    @EventField
    public String getOutputTableName() {
        return this.outputTableName;
    }

    @EventField
    public Double getCpuTimeSecs() {
        return this.cpuTimeSecs;
    }

    @EventField
    public Double getWallTimeSecs() {
        return this.wallTimeSecs;
    }

    @EventField
    public Long getPeakTotalMemoryBytes() {
        return this.peakTotalMemoryBytes;
    }

    @EventField
    public Long getPeakTaskTotalMemoryBytes() {
        return this.peakTaskTotalMemoryBytes;
    }

    @EventField
    public String getExtraStats() {
        return this.extraStats;
    }

    public static Builder builder(String catalog, String schema, String originalQuery, Map<String, String> sessionProperties) {
        return new Builder(catalog, schema, originalQuery, sessionProperties);
    }

    public static class Builder {
        private final String catalog;
        private final String schema;
        private final String originalQuery;
        private final Map<String, String> sessionProperties;
        private List<String> setupQueryIds = ImmutableList.of();
        private List<String> teardownQueryIds = ImmutableList.of();
        private Optional<String> checksumQueryId = Optional.empty();
        private Optional<String> query = Optional.empty();
        private Optional<List<String>> setupQueries = Optional.empty();
        private Optional<List<String>> teardownQueries = Optional.empty();
        private Optional<String> checksumQuery = Optional.empty();
        private Optional<String> jsonPlan = Optional.empty();
        private Optional<QueryActionStats> queryActionStats = Optional.empty();
        private Optional<String> outputTableName = Optional.empty();

        private Builder(String catalog, String schema, String originalQuery, Map<String, String> sessionProperties) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            this.schema = Objects.requireNonNull(schema, "schema is null");
            this.originalQuery = Objects.requireNonNull(originalQuery, "originalQuery is null");
            this.sessionProperties = ImmutableMap.copyOf(sessionProperties);
        }

        public Builder setSetupQueryIds(List<String> setupQueryIds) {
            this.setupQueryIds = ImmutableList.copyOf(setupQueryIds);
            return this;
        }

        public Builder setTeardownQueryIds(List<String> teardownQueryIds) {
            this.teardownQueryIds = ImmutableList.copyOf(teardownQueryIds);
            return this;
        }

        public Builder setChecksumQueryId(Optional<String> checksumQueryId) {
            this.checksumQueryId = Objects.requireNonNull(checksumQueryId, "checksumQueryId is null");
            return this;
        }

        public Builder setQuery(Optional<String> query) {
            this.query = Objects.requireNonNull(query, "query is null");
            return this;
        }

        public Builder setSetupQueries(Optional<List<String>> setupQueries) {
            this.setupQueries = Objects.requireNonNull(setupQueries, "setupQueries is null");
            return this;
        }

        public Builder setTeardownQueries(Optional<List<String>> teardownQueries) {
            this.teardownQueries = Objects.requireNonNull(teardownQueries, "teardownQueries is null");
            return this;
        }

        public Builder setChecksumQuery(Optional<String> checksumQuery) {
            this.checksumQuery = Objects.requireNonNull(checksumQuery, "checksumQuery is null");
            return this;
        }

        public Builder setJsonPlan(String jsonPlan) {
            this.jsonPlan = Optional.of(jsonPlan);
            return this;
        }

        public Builder setQueryActionStats(Optional<QueryActionStats> queryActionStats) {
            this.queryActionStats = Objects.requireNonNull(queryActionStats, "queryActionStats is null");
            return this;
        }

        public Builder setOutputTableName(Optional<String> outputTableName) {
            this.outputTableName = Objects.requireNonNull(outputTableName, "outputTableName is null");
            return this;
        }

        public QueryInfo build() {
            return new QueryInfo(this.catalog, this.schema, this.originalQuery, this.sessionProperties, this.setupQueryIds, this.teardownQueryIds, this.checksumQueryId, this.query, this.setupQueries, this.teardownQueries, this.checksumQuery, this.jsonPlan, this.queryActionStats, this.outputTableName);
        }
    }
}

