/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.event;

import com.facebook.airlift.event.client.EventField;
import com.facebook.airlift.event.client.EventType;
import com.facebook.presto.spi.ErrorType;
import com.facebook.presto.verifier.framework.QueryStage;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@EventType(value="QueryFailure")
@Immutable
public class QueryFailure {
    private final String clusterType;
    private final String queryStage;
    private final String errorCode;
    private final String errorType;
    private final boolean retryable;
    private final String prestoQueryId;
    private final String stacktrace;

    public QueryFailure(QueryStage queryStage, String errorCode, Optional<ErrorType> errorType, boolean retryable, Optional<String> prestoQueryId, String stacktrace) {
        this.queryStage = Objects.requireNonNull(queryStage.name(), "queryStage is null");
        this.clusterType = Objects.requireNonNull(queryStage.getTargetCluster().name(), "cluster is null");
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null");
        this.errorType = errorType.map(Enum::name).orElse(null);
        this.retryable = retryable;
        this.prestoQueryId = prestoQueryId.orElse(null);
        this.stacktrace = Objects.requireNonNull(stacktrace, "stacktrace is null");
    }

    @EventField
    public String getClusterType() {
        return this.clusterType;
    }

    @EventField
    public String getQueryStage() {
        return this.queryStage;
    }

    @EventField
    public String getErrorCode() {
        return this.errorCode;
    }

    @EventField
    public String getErrorType() {
        return this.errorType;
    }

    @EventField
    public boolean isRetryable() {
        return this.retryable;
    }

    @EventField
    public String getPrestoQueryId() {
        return this.prestoQueryId;
    }

    @EventField
    public String getStacktrace() {
        return this.stacktrace;
    }
}

