/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.event;

import com.facebook.airlift.event.client.EventField;
import com.facebook.airlift.event.client.EventType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@EventType(value="DeterminismAnalysisRun")
@Immutable
public class DeterminismAnalysisRun {
    private final String tableName;
    private final String queryId;
    private final List<String> setupQueryIds;
    private final List<String> teardownQueryIds;
    private final String checksumQueryId;

    private DeterminismAnalysisRun(Optional<String> tableName, Optional<String> queryId, List<String> setupQueryIds, List<String> teardownQueryIds, Optional<String> checksumQueryId) {
        this.tableName = tableName.orElse(null);
        this.queryId = queryId.orElse(null);
        this.setupQueryIds = ImmutableList.copyOf(setupQueryIds);
        this.teardownQueryIds = ImmutableList.copyOf(teardownQueryIds);
        this.checksumQueryId = checksumQueryId.orElse(null);
    }

    @EventField
    public String getTableName() {
        return this.tableName;
    }

    @EventField
    public String getQueryId() {
        return this.queryId;
    }

    @EventField
    public List<String> getSetupQueryIds() {
        return this.setupQueryIds;
    }

    @EventField
    public List<String> getTeardownQueryIds() {
        return this.teardownQueryIds;
    }

    @EventField
    public String getChecksumQueryId() {
        return this.checksumQueryId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<String> tableName = Optional.empty();
        private Optional<String> queryId = Optional.empty();
        private ImmutableList.Builder<String> setupQueryIds = ImmutableList.builder();
        private ImmutableList.Builder<String> teardownQueryIds = ImmutableList.builder();
        private Optional<String> checksumQueryId = Optional.empty();

        private Builder() {
        }

        public Builder setTableName(String tableName) {
            Preconditions.checkState((!this.tableName.isPresent() ? 1 : 0) != 0, (Object)"tableName is already set");
            this.tableName = Optional.of(tableName);
            return this;
        }

        public Builder setQueryId(String queryId) {
            Preconditions.checkState((!this.queryId.isPresent() ? 1 : 0) != 0, (Object)"queryId is already set");
            this.queryId = Optional.of(queryId);
            return this;
        }

        public Builder addSetupQueryId(String queryId) {
            this.setupQueryIds.add((Object)queryId);
            return this;
        }

        public Builder addTeardownQueryId(String queryId) {
            this.teardownQueryIds.add((Object)queryId);
            return this;
        }

        public Builder setChecksumQueryId(String checksumQueryId) {
            Preconditions.checkState((!this.checksumQueryId.isPresent() ? 1 : 0) != 0, (Object)"checksumQueryId is already set");
            this.checksumQueryId = Optional.of(checksumQueryId);
            return this;
        }

        public DeterminismAnalysisRun build() {
            return new DeterminismAnalysisRun(this.tableName, this.queryId, (List)this.setupQueryIds.build(), (List)this.teardownQueryIds.build(), this.checksumQueryId);
        }
    }
}

