/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.verifier.checksum.ColumnChecksum;
import java.util.Objects;
import javax.annotation.Nullable;

public class FloatingPointColumnChecksum
extends ColumnChecksum {
    private final Object sum;
    private final long nanCount;
    private final long positiveInfinityCount;
    private final long negativeInfinityCount;
    private final long rowCount;

    public FloatingPointColumnChecksum(@Nullable Object sum, long nanCount, long positiveInfinityCount, long negativeInfinityCount, long rowCount) {
        this.sum = sum;
        this.positiveInfinityCount = positiveInfinityCount;
        this.negativeInfinityCount = negativeInfinityCount;
        this.nanCount = nanCount;
        this.rowCount = rowCount;
    }

    @Nullable
    public Object getSum() {
        return this.sum;
    }

    public long getNanCount() {
        return this.nanCount;
    }

    public long getPositiveInfinityCount() {
        return this.positiveInfinityCount;
    }

    public long getNegativeInfinityCount() {
        return this.negativeInfinityCount;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FloatingPointColumnChecksum o = (FloatingPointColumnChecksum)obj;
        return Objects.equals(this.sum, o.sum) && Objects.equals(this.nanCount, o.nanCount) && Objects.equals(this.positiveInfinityCount, o.positiveInfinityCount) && Objects.equals(this.negativeInfinityCount, o.negativeInfinityCount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sum, this.nanCount, this.positiveInfinityCount, this.negativeInfinityCount);
    }

    @Override
    public String toString() {
        String mean = this.rowCount > 0L && this.sum != null ? ", mean: " + (Double)this.sum / (double)this.rowCount : "";
        return String.format("sum: %s, NaN: %s, +infinity: %s, -infinity: %s%s", this.sum, this.nanCount, this.positiveInfinityCount, this.negativeInfinityCount, mean);
    }
}

