/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.ShowCreate;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.annotation.ForTest;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryObjectBundle;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.resolver.ClusterSizeSupplier;
import com.facebook.presto.verifier.resolver.FailureResolver;
import com.facebook.presto.verifier.resolver.FailureResolverFactory;
import com.facebook.presto.verifier.resolver.FailureResolverFactoryContext;
import com.facebook.presto.verifier.resolver.FailureResolverUtil;
import com.facebook.presto.verifier.resolver.TooManyOpenPartitionsFailureResolverConfig;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Inject;

public class TooManyOpenPartitionsFailureResolver
implements FailureResolver {
    public static final String NAME = "too-many-open-partitions";
    private static final Logger log = Logger.get(TooManyOpenPartitionsFailureResolver.class);
    private final SqlParser sqlParser;
    private final PrestoAction prestoAction;
    private final Supplier<Integer> testClusterSizeSupplier;
    private final int maxBucketPerWriter;

    @Inject
    public TooManyOpenPartitionsFailureResolver(SqlParser sqlParser, PrestoAction prestoAction, Supplier<Integer> testClusterSizeSupplier, int maxBucketPerWriter) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.prestoAction = Objects.requireNonNull(prestoAction, "prestoAction is null");
        this.testClusterSizeSupplier = Objects.requireNonNull(testClusterSizeSupplier, "testClusterSizeSupplier is null");
        this.maxBucketPerWriter = maxBucketPerWriter;
    }

    @Override
    public Optional<String> resolveQueryFailure(QueryStats controlQueryStats, QueryException queryException, Optional<QueryObjectBundle> test) {
        if (!test.isPresent()) {
            return Optional.empty();
        }
        return FailureResolverUtil.mapMatchingPrestoException(queryException, QueryStage.TEST_MAIN, (Set<ErrorCodeSupplier>)ImmutableSet.of((Object)HiveErrorCode.HIVE_TOO_MANY_OPEN_PARTITIONS), e -> {
            try {
                ShowCreate showCreate = new ShowCreate(ShowCreate.Type.TABLE, ((QueryObjectBundle)test.get()).getObjectName());
                String showCreateResult = (String)Iterables.getOnlyElement(this.prestoAction.execute((Statement)showCreate, QueryStage.DESCRIBE, resultSet -> Optional.of(resultSet.getString(1))).getResults());
                CreateTable createTable = (CreateTable)this.sqlParser.createStatement(showCreateResult, ParsingOptions.builder().setDecimalLiteralTreatment(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE).build());
                List bucketCountProperty = (List)createTable.getProperties().stream().filter(property -> property.getName().getValue().equals("bucket_count")).collect(ImmutableList.toImmutableList());
                if (bucketCountProperty.size() != 1) {
                    return Optional.empty();
                }
                long bucketCount = ((LongLiteral)((Property)Iterables.getOnlyElement((Iterable)bucketCountProperty)).getValue()).getValue();
                int testClusterSize = this.testClusterSizeSupplier.get();
                if ((long)(testClusterSize * this.maxBucketPerWriter) < bucketCount) {
                    return Optional.of("Not enough workers on test cluster");
                }
                return Optional.empty();
            }
            catch (Throwable t) {
                log.warn(t, "Exception when resolving HIVE_TOO_MANY_OPEN_PARTITIONS");
                return Optional.empty();
            }
        });
    }

    public static class Factory
    implements FailureResolverFactory {
        private final ClusterSizeSupplier testClusterSizeSupplier;
        private final Duration clusterSizeExpiration;
        private final int maxBucketPerWriter;

        @Inject
        public Factory(@ForTest ClusterSizeSupplier testClusterSizeSupplier, TooManyOpenPartitionsFailureResolverConfig config) {
            this.testClusterSizeSupplier = Objects.requireNonNull(testClusterSizeSupplier, "testClusterSizeSupplier is null");
            this.clusterSizeExpiration = Objects.requireNonNull(config.getClusterSizeExpiration(), "clusterSizeExpiration is null");
            this.maxBucketPerWriter = config.getMaxBucketsPerWriter();
        }

        @Override
        public FailureResolver create(FailureResolverFactoryContext context) {
            return new TooManyOpenPartitionsFailureResolver(context.getSqlParser(), context.getPrestoAction(), (Supplier<Integer>)Suppliers.memoizeWithExpiration(this.testClusterSizeSupplier::getClusterSize, (long)this.clusterSizeExpiration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS), this.maxBucketPerWriter);
        }
    }
}

