/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class QueryActionsConfig {
    private String controlQueryActionType = "presto-jdbc";
    private String testQueryActionType = "presto-jdbc";
    private boolean runHelperQueriesOnControl = true;
    private Duration metadataTimeout = new Duration(3.0, TimeUnit.MINUTES);
    private Duration checksumTimeout = new Duration(30.0, TimeUnit.MINUTES);

    @NotNull
    public String getControlQueryActionType() {
        return this.controlQueryActionType;
    }

    @Config(value="control.query-action-type")
    public QueryActionsConfig setControlQueryActionType(String controlQueryActionType) {
        this.controlQueryActionType = controlQueryActionType;
        return this;
    }

    @NotNull
    public String getTestQueryActionType() {
        return this.testQueryActionType;
    }

    @Config(value="test.query-action-type")
    public QueryActionsConfig setTestQueryActionType(String testQueryActionType) {
        this.testQueryActionType = testQueryActionType;
        return this;
    }

    public boolean isRunHelperQueriesOnControl() {
        return this.runHelperQueriesOnControl;
    }

    @Config(value="run-helper-queries-on-control")
    public QueryActionsConfig setRunHelperQueriesOnControl(boolean runHelperQueriesOnControl) {
        this.runHelperQueriesOnControl = runHelperQueriesOnControl;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getMetadataTimeout() {
        return this.metadataTimeout;
    }

    @Config(value="metadata-timeout")
    public QueryActionsConfig setMetadataTimeout(Duration metadataTimeout) {
        this.metadataTimeout = metadataTimeout;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getChecksumTimeout() {
        return this.checksumTimeout;
    }

    @Config(value="checksum-timeout")
    public QueryActionsConfig setChecksumTimeout(Duration checksumTimeout) {
        this.checksumTimeout = checksumTimeout;
        return this;
    }
}

