/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.verifier.checksum.ColumnChecksum;
import com.facebook.presto.verifier.framework.Column;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class ColumnMatchResult<T extends ColumnChecksum> {
    private final boolean matched;
    private final Column column;
    private final Optional<String> message;
    private final T controlColumnChecksum;
    private final T testColumnChecksum;

    public ColumnMatchResult(boolean matched, Column column, T controlColumnChecksum, T testColumnChecksum) {
        this(matched, column, Optional.empty(), controlColumnChecksum, testColumnChecksum);
    }

    public ColumnMatchResult(boolean matched, Column column, Optional<String> message, T controlColumnChecksum, T testColumnChecksum) {
        this.matched = matched;
        this.column = Objects.requireNonNull(column, "column is null");
        this.message = Objects.requireNonNull(message, "message is null");
        this.controlColumnChecksum = (ColumnChecksum)Objects.requireNonNull(controlColumnChecksum, "controlColumnChecksum is null");
        this.testColumnChecksum = (ColumnChecksum)Objects.requireNonNull(testColumnChecksum, "testColumnChecksum is null");
    }

    public boolean isMatched() {
        return this.matched;
    }

    public Column getColumn() {
        return this.column;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public T getControlChecksum() {
        return this.controlColumnChecksum;
    }

    public T getTestChecksum() {
        return this.testColumnChecksum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnMatchResult o = (ColumnMatchResult)obj;
        return Objects.equals(this.matched, o.matched) && Objects.equals(this.column, o.column) && Objects.equals(this.controlColumnChecksum, o.controlColumnChecksum) && Objects.equals(this.testColumnChecksum, o.testColumnChecksum);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.controlColumnChecksum, this.testColumnChecksum);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("matched", this.matched).add("column", (Object)this.column).add("controlColumnChecksum", this.controlColumnChecksum).add("testColumnChecksum", this.testColumnChecksum).toString();
    }
}

