/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;

public class TooManyOpenPartitionsFailureResolverConfig {
    private int maxBucketsPerWriter = 100;
    private Duration clusterSizeExpiration = new Duration(30.0, TimeUnit.MINUTES);

    @Min(value=1L)
    public @Min(value=1L) int getMaxBucketsPerWriter() {
        return this.maxBucketsPerWriter;
    }

    @Config(value="failure-resolver.max-buckets-per-writer")
    public TooManyOpenPartitionsFailureResolverConfig setMaxBucketsPerWriter(int maxBucketsPerWriter) {
        this.maxBucketsPerWriter = maxBucketsPerWriter;
        return this;
    }

    @MinDuration(value="1m")
    public Duration getClusterSizeExpiration() {
        return this.clusterSizeExpiration;
    }

    @Config(value="failure-resolver.cluster-size-expiration")
    public TooManyOpenPartitionsFailureResolverConfig setClusterSizeExpiration(Duration clusterSizeExpiration) {
        this.clusterSizeExpiration = clusterSizeExpiration;
        return this;
    }
}

