/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.StringResponseHandler;
import com.facebook.airlift.json.ObjectMapperProvider;
import com.facebook.presto.verifier.prestoaction.PrestoActionConfig;
import com.facebook.presto.verifier.prestoaction.PrestoExceptionClassifier;
import com.facebook.presto.verifier.resolver.ClusterSizeSupplier;
import com.facebook.presto.verifier.retry.RetryConfig;
import com.facebook.presto.verifier.retry.RetryDriver;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Response;

public class ClusterSizeFetcher
implements ClusterSizeSupplier {
    private static final String PATH = "/v1/node";
    private final HttpClient httpClient;
    private final URI nodeResourceUri;
    private final RetryDriver<RuntimeException> networkRetry;

    public ClusterSizeFetcher(HttpClient httpClient, PrestoActionConfig prestoAddress, RetryConfig networkRetryConfig) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.nodeResourceUri = (URI)Objects.requireNonNull(Iterables.getOnlyElement(prestoAddress.getHttpUris(PATH)), "nodeResourceUri is null");
        this.networkRetry = new RetryDriver<RuntimeException>(networkRetryConfig, PrestoExceptionClassifier::isClusterConnectionException, RuntimeException.class, e -> {});
    }

    @Override
    public int getClusterSize() {
        return this.networkRetry.run("fetchClusterSize", this::fetchClusterSize);
    }

    private int fetchClusterSize() {
        List values;
        Request request = Request.Builder.prepareGet().setUri(this.nodeResourceUri).setHeader("Content-Type", "application/json").build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.httpClient.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Preconditions.checkState((response.getStatusCode() == Response.Status.OK.getStatusCode() ? 1 : 0) != 0, (String)"Invalid response: %s %s", (int)response.getStatusCode(), (Object)response.getStatusMessage());
        try {
            values = (List)new ObjectMapperProvider().get().readValue(response.getBody(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return values.size();
    }
}

