/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.event.DeterminismAnalysisDetails;
import com.facebook.presto.verifier.framework.AbstractVerification;
import com.facebook.presto.verifier.framework.ChecksumQueryContext;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.DataMatchResult;
import com.facebook.presto.verifier.framework.DataVerificationUtil;
import com.facebook.presto.verifier.framework.DeterminismAnalyzer;
import com.facebook.presto.verifier.framework.QueryObjectBundle;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.QueryState;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.QueryActions;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.resolver.FailureResolverManager;
import com.facebook.presto.verifier.rewrite.QueryRewriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DataVerification
extends AbstractVerification<QueryObjectBundle, DataMatchResult, Void> {
    private final QueryRewriter queryRewriter;
    private final DeterminismAnalyzer determinismAnalyzer;
    private final FailureResolverManager failureResolverManager;
    private final TypeManager typeManager;
    private final ChecksumValidator checksumValidator;

    public DataVerification(QueryActions queryActions, SourceQuery sourceQuery, QueryRewriter queryRewriter, DeterminismAnalyzer determinismAnalyzer, FailureResolverManager failureResolverManager, SqlExceptionClassifier exceptionClassifier, VerificationContext verificationContext, VerifierConfig verifierConfig, TypeManager typeManager, ChecksumValidator checksumValidator) {
        super(queryActions, sourceQuery, exceptionClassifier, verificationContext, Optional.empty(), verifierConfig);
        this.queryRewriter = Objects.requireNonNull(queryRewriter, "queryRewriter is null");
        this.determinismAnalyzer = Objects.requireNonNull(determinismAnalyzer, "determinismAnalyzer is null");
        this.failureResolverManager = Objects.requireNonNull(failureResolverManager, "failureResolverManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.checksumValidator = Objects.requireNonNull(checksumValidator, "checksumValidator is null");
    }

    @Override
    protected QueryObjectBundle getQueryRewrite(ClusterType clusterType) {
        return this.queryRewriter.rewriteQuery(this.getSourceQuery().getQuery(clusterType), clusterType);
    }

    @Override
    public DataMatchResult verify(QueryObjectBundle control, QueryObjectBundle test, Optional<QueryResult<Void>> controlQueryResult, Optional<QueryResult<Void>> testQueryResult, ChecksumQueryContext controlContext, ChecksumQueryContext testContext) {
        List<Column> controlColumns = DataVerificationUtil.getColumns(this.getHelperAction(), this.typeManager, control.getObjectName());
        List<Column> testColumns = DataVerificationUtil.getColumns(this.getHelperAction(), this.typeManager, test.getObjectName());
        Query controlChecksumQuery = this.checksumValidator.generateChecksumQuery(control.getObjectName(), controlColumns);
        Query testChecksumQuery = this.checksumValidator.generateChecksumQuery(test.getObjectName(), testColumns);
        controlContext.setChecksumQuery(DataVerification.formatSql((Statement)controlChecksumQuery));
        testContext.setChecksumQuery(DataVerification.formatSql((Statement)testChecksumQuery));
        QueryResult controlChecksum = VerifierUtil.callAndConsume(() -> this.getHelperAction().execute((Statement)controlChecksumQuery, QueryStage.CONTROL_CHECKSUM, ChecksumResult::fromResultSet), stats -> stats.getQueryStats().map(QueryStats::getQueryId).ifPresent(controlContext::setChecksumQueryId));
        QueryResult testChecksum = VerifierUtil.callAndConsume(() -> this.getHelperAction().execute((Statement)testChecksumQuery, QueryStage.TEST_CHECKSUM, ChecksumResult::fromResultSet), stats -> stats.getQueryStats().map(QueryStats::getQueryId).ifPresent(testContext::setChecksumQueryId));
        return DataVerificationUtil.match(this.checksumValidator, controlColumns, testColumns, (ChecksumResult)Iterables.getOnlyElement(controlChecksum.getResults()), (ChecksumResult)Iterables.getOnlyElement(testChecksum.getResults()));
    }

    @Override
    protected DeterminismAnalysisDetails analyzeDeterminism(QueryObjectBundle control, DataMatchResult matchResult) {
        return this.determinismAnalyzer.analyze(control, matchResult.getControlChecksum());
    }

    @Override
    protected Optional<String> resolveFailure(Optional<QueryObjectBundle> control, Optional<QueryObjectBundle> test, AbstractVerification.QueryContext controlQueryContext, Optional<DataMatchResult> matchResult, Optional<Throwable> throwable) {
        if (matchResult.isPresent() && !matchResult.get().isMatched()) {
            Preconditions.checkState((boolean)control.isPresent(), (Object)"control is missing");
            return this.failureResolverManager.resolveResultMismatch(matchResult.get(), control.get());
        }
        if (throwable.isPresent() && controlQueryContext.getState() == QueryState.SUCCEEDED) {
            Preconditions.checkState((boolean)controlQueryContext.getMainQueryStats().isPresent(), (Object)"controlQueryStats is missing");
            return this.failureResolverManager.resolveException(controlQueryContext.getMainQueryStats().get(), throwable.get(), test);
        }
        return Optional.empty();
    }
}

