/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.airlift.configuration.Config;
import com.facebook.presto.verifier.prestoaction.PrestoAddress;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class PrestoClusterConfig
implements PrestoAddress {
    private String host;
    private int jdbcPort;
    private int httpPort;
    private Map<String, String> jdbcUrlParameters = ImmutableMap.of();
    private Duration queryTimeout = new Duration(60.0, TimeUnit.MINUTES);
    private Duration metadataTimeout = new Duration(3.0, TimeUnit.MINUTES);
    private Duration checksumTimeout = new Duration(30.0, TimeUnit.MINUTES);

    @Override
    @NotNull
    public String getHost() {
        return this.host;
    }

    @Config(value="host")
    public PrestoClusterConfig setHost(String host) {
        this.host = host;
        return this;
    }

    @Override
    @Min(value=0L)
    @Max(value=65535L)
    public @Min(value=0L) @Max(value=65535L) int getJdbcPort() {
        return this.jdbcPort;
    }

    @Config(value="jdbc-port")
    public PrestoClusterConfig setJdbcPort(int jdbcPort) {
        this.jdbcPort = jdbcPort;
        return this;
    }

    @Override
    @Min(value=0L)
    @Max(value=65535L)
    public @Min(value=0L) @Max(value=65535L) int getHttpPort() {
        return this.httpPort;
    }

    @Config(value="http-port")
    public PrestoClusterConfig setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    @Override
    @NotNull
    public Map<String, String> getJdbcUrlParameters() {
        return this.jdbcUrlParameters;
    }

    @Config(value="jdbc-url-parameters")
    public PrestoClusterConfig setJdbcUrlParameters(String jdbcUrlParameters) {
        if (jdbcUrlParameters == null) {
            return this;
        }
        try {
            this.jdbcUrlParameters = (Map)new ObjectMapper().readValue(jdbcUrlParameters, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @MinDuration(value="1s")
    public Duration getQueryTimeout() {
        return this.queryTimeout;
    }

    @Config(value="query-timeout")
    public PrestoClusterConfig setQueryTimeout(Duration queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getMetadataTimeout() {
        return this.metadataTimeout;
    }

    @Config(value="metadata-timeout")
    public PrestoClusterConfig setMetadataTimeout(Duration metadataTimeout) {
        this.metadataTimeout = metadataTimeout;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getChecksumTimeout() {
        return this.checksumTimeout;
    }

    @Config(value="checksum-timeout")
    public PrestoClusterConfig setChecksumTimeout(Duration checksumTimeout) {
        this.checksumTimeout = checksumTimeout;
        return this;
    }
}

