/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.framework.UnsupportedQueryTypeException;
import java.util.Objects;

public enum QueryType {
    CREATE_TABLE_AS_SELECT(Category.DATA_PRODUCING, CreateTableAsSelect.class),
    INSERT(Category.DATA_PRODUCING, Insert.class),
    QUERY(Category.DATA_PRODUCING, Query.class),
    SHOW_CATALOGS(Category.METADATA_READ, ShowCatalogs.class),
    SHOW_COLUMNS(Category.METADATA_READ, ShowColumns.class),
    SHOW_FUNCTIONS(Category.METADATA_READ, ShowFunctions.class),
    SHOW_SCHEMAS(Category.METADATA_READ, ShowSchemas.class),
    SHOW_SESSION(Category.METADATA_READ, ShowSession.class),
    SHOW_TABLES(Category.METADATA_READ, ShowTables.class);

    private final Category category;
    private final Class<? extends Statement> statementClass;

    private QueryType(Category category, Class<? extends Statement> statementClass) {
        this.category = Objects.requireNonNull(category, "category is null");
        this.statementClass = Objects.requireNonNull(statementClass, "statementClass is null");
    }

    public static QueryType of(Statement statement) {
        for (QueryType queryType : QueryType.values()) {
            if (!queryType.statementClass.isAssignableFrom(statement.getClass())) continue;
            return queryType;
        }
        throw new UnsupportedQueryTypeException(statement.getClass().getSimpleName());
    }

    public Category getCategory() {
        return this.category;
    }

    public static enum Category {
        DATA_PRODUCING,
        METADATA_READ;

    }
}

