/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.verifier.framework.ClusterType;
import com.google.common.base.Preconditions;
import java.util.Objects;

public enum QueryStage {
    CONTROL_SETUP(ClusterType.CONTROL),
    CONTROL_MAIN(ClusterType.CONTROL),
    CONTROL_TEARDOWN(ClusterType.CONTROL),
    CONTROL_CHECKSUM(ClusterType.CONTROL),
    TEST_SETUP(ClusterType.TEST),
    TEST_MAIN(ClusterType.TEST),
    TEST_TEARDOWN(ClusterType.TEST),
    TEST_CHECKSUM(ClusterType.CONTROL),
    REWRITE(ClusterType.CONTROL),
    DESCRIBE(ClusterType.CONTROL),
    DETERMINISM_ANALYSIS_SETUP(ClusterType.CONTROL),
    DETERMINISM_ANALYSIS_MAIN(ClusterType.CONTROL),
    DETERMINISM_ANALYSIS_CHECKSUM(ClusterType.CONTROL);

    private final ClusterType targetCluster;

    private QueryStage(ClusterType targetCluster) {
        this.targetCluster = Objects.requireNonNull(targetCluster, "targetCluster is null");
    }

    public ClusterType getTargetCluster() {
        return this.targetCluster;
    }

    public boolean isSetup() {
        return this == CONTROL_SETUP || this == TEST_SETUP;
    }

    public boolean isMain() {
        return this == CONTROL_MAIN || this == TEST_MAIN;
    }

    public boolean isTeardown() {
        return this == CONTROL_TEARDOWN || this == TEST_TEARDOWN;
    }

    public static QueryStage forSetup(ClusterType cluster) {
        Preconditions.checkState((cluster == ClusterType.CONTROL || cluster == ClusterType.TEST ? 1 : 0) != 0, (String)"Invalid cluster: %s", (Object)((Object)cluster));
        return cluster == ClusterType.CONTROL ? CONTROL_SETUP : TEST_SETUP;
    }

    public static QueryStage forMain(ClusterType cluster) {
        Preconditions.checkState((cluster == ClusterType.CONTROL || cluster == ClusterType.TEST ? 1 : 0) != 0, (String)"Invalid cluster: %s", (Object)((Object)cluster));
        return cluster == ClusterType.CONTROL ? CONTROL_MAIN : TEST_MAIN;
    }

    public static QueryStage forTeardown(ClusterType cluster) {
        Preconditions.checkState((cluster == ClusterType.CONTROL || cluster == ClusterType.TEST ? 1 : 0) != 0, (String)"Invalid cluster: %s", (Object)((Object)cluster));
        return cluster == ClusterType.CONTROL ? CONTROL_TEARDOWN : TEST_TEARDOWN;
    }
}

