/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.event;

import com.facebook.airlift.event.client.EventField;
import com.facebook.airlift.event.client.EventType;
import com.facebook.presto.verifier.event.DeterminismAnalysisDetails;
import com.facebook.presto.verifier.event.QueryFailure;
import com.facebook.presto.verifier.event.QueryInfo;
import com.facebook.presto.verifier.framework.DeterminismAnalysis;
import com.facebook.presto.verifier.framework.SkippedReason;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@EventType(value="VerifierQuery")
@Immutable
public class VerifierQueryEvent {
    private final String suite;
    private final String testId;
    private final String name;
    private final String status;
    private final String skippedReason;
    private final Boolean deterministic;
    private final String determinismAnalysis;
    private final DeterminismAnalysisDetails determinismAnalysisDetails;
    private final String resolveMessage;
    private final QueryInfo controlQueryInfo;
    private final QueryInfo testQueryInfo;
    private final String errorCode;
    private final String errorMessage;
    private final QueryFailure finalQueryFailure;
    private final List<QueryFailure> queryFailures;
    private final int resubmissionCount;

    public VerifierQueryEvent(String suite, String testId, String name, EventStatus status, Optional<SkippedReason> skippedReason, Optional<DeterminismAnalysis> determinismAnalysis, Optional<DeterminismAnalysisDetails> determinismAnalysisDetails, Optional<String> resolveMessage, QueryInfo controlQueryInfo, QueryInfo testQueryInfo, Optional<String> errorCode, Optional<String> errorMessage, Optional<QueryFailure> finalQueryFailure, List<QueryFailure> queryFailures, int resubmissionCount) {
        this.suite = Objects.requireNonNull(suite, "suite is null");
        this.testId = Objects.requireNonNull(testId, "testId is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.status = status.name();
        this.skippedReason = skippedReason.map(Enum::name).orElse(null);
        this.deterministic = determinismAnalysis.filter(d -> !d.isUnknown()).map(DeterminismAnalysis::isDeterministic).orElse(null);
        this.determinismAnalysis = determinismAnalysis.map(Enum::name).orElse(null);
        this.determinismAnalysisDetails = determinismAnalysisDetails.orElse(null);
        this.resolveMessage = resolveMessage.orElse(null);
        this.controlQueryInfo = Objects.requireNonNull(controlQueryInfo, "controlQueryInfo is null");
        this.testQueryInfo = Objects.requireNonNull(testQueryInfo, "testQueryInfo is null");
        this.errorCode = errorCode.orElse(null);
        this.errorMessage = errorMessage.orElse(null);
        this.finalQueryFailure = finalQueryFailure.orElse(null);
        this.queryFailures = ImmutableList.copyOf(queryFailures);
        this.resubmissionCount = resubmissionCount;
    }

    public static VerifierQueryEvent skipped(String suite, String testId, SourceQuery sourceQuery, SkippedReason skippedReason) {
        return new VerifierQueryEvent(suite, testId, sourceQuery.getName(), EventStatus.SKIPPED, Optional.of(skippedReason), Optional.empty(), Optional.empty(), Optional.empty(), new QueryInfo(sourceQuery.getControlConfiguration().getCatalog(), sourceQuery.getControlConfiguration().getSchema(), sourceQuery.getControlQuery()), new QueryInfo(sourceQuery.getTestConfiguration().getCatalog(), sourceQuery.getTestConfiguration().getSchema(), sourceQuery.getTestQuery()), Optional.empty(), Optional.empty(), Optional.empty(), (List<QueryFailure>)ImmutableList.of(), 0);
    }

    @EventField
    public String getSuite() {
        return this.suite;
    }

    @EventField
    public String getTestId() {
        return this.testId;
    }

    @EventField
    public String getName() {
        return this.name;
    }

    @EventField
    public String getStatus() {
        return this.status;
    }

    @EventField
    public String getSkippedReason() {
        return this.skippedReason;
    }

    @EventField
    @Deprecated
    public Boolean getDeterministic() {
        return this.deterministic;
    }

    @EventField
    public String getDeterminismAnalysis() {
        return this.determinismAnalysis;
    }

    @EventField
    public DeterminismAnalysisDetails getDeterminismAnalysisDetails() {
        return this.determinismAnalysisDetails;
    }

    @EventField
    public String getResolveMessage() {
        return this.resolveMessage;
    }

    @EventField
    public QueryInfo getControlQueryInfo() {
        return this.controlQueryInfo;
    }

    @EventField
    public QueryInfo getTestQueryInfo() {
        return this.testQueryInfo;
    }

    @EventField
    public String getErrorCode() {
        return this.errorCode;
    }

    @EventField
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @EventField
    public QueryFailure getFinalQueryFailure() {
        return this.finalQueryFailure;
    }

    @EventField
    public List<QueryFailure> getQueryFailures() {
        return this.queryFailures;
    }

    @EventField
    public int getResubmissionCount() {
        return this.resubmissionCount;
    }

    public static enum EventStatus {
        SUCCEEDED,
        FAILED,
        FAILED_RESOLVED,
        SKIPPED;

    }
}

