/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.collect.ImmutableSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Set;

public class Column {
    private static final Set<Type> FLOATING_POINT_TYPES = ImmutableSet.of((Object)DoubleType.DOUBLE, (Object)RealType.REAL);
    private final String name;
    private final Expression expression;
    private final Category category;
    private final Type type;

    private Column(String name, Expression expression, Category category, Type type) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.category = Objects.requireNonNull(category, "kind is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public String getName() {
        return this.name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Category getCategory() {
        return this.category;
    }

    public Type getType() {
        return this.type;
    }

    public static Column fromResultSet(TypeManager typeManager, ResultSet resultSet) throws SQLException {
        String columnName = resultSet.getString("Column");
        Type type = typeManager.getType(TypeSignature.parseTypeSignature((String)resultSet.getString("Type")));
        return Column.create(columnName, (Expression)VerifierUtil.delimitedIdentifier(columnName), type);
    }

    public static Column create(String name, Expression expression, Type type) {
        Category category = FLOATING_POINT_TYPES.contains(type) ? Category.FLOATING_POINT : (type instanceof ArrayType ? Category.ARRAY : (type instanceof MapType ? Category.MAP : (type instanceof RowType ? Category.ROW : Category.SIMPLE)));
        return new Column(name, expression, category, type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Column o = (Column)obj;
        return Objects.equals(this.name, o.name) && Objects.equals((Object)this.category, (Object)o.category) && Objects.equals(this.type, o.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.category, this.type});
    }

    public static enum Category {
        SIMPLE,
        FLOATING_POINT,
        ARRAY,
        ROW,
        MAP;

    }
}

