/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.event;

import com.facebook.airlift.event.client.AbstractEventClient;
import com.facebook.presto.verifier.event.VerifierQueryEvent;
import com.facebook.presto.verifier.framework.VerifierConfig;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Objects;
import javax.inject.Inject;

public class HumanReadableEventClient
extends AbstractEventClient {
    private final PrintStream out;

    @Inject
    public HumanReadableEventClient(VerifierConfig config) throws FileNotFoundException {
        Objects.requireNonNull(config.getHumanReadableEventLogFile(), "humanReadableEventLogFile is null");
        this.out = config.getHumanReadableEventLogFile().isPresent() ? new PrintStream(config.getHumanReadableEventLogFile().get()) : System.out;
    }

    protected <T> void postEvent(T event) {
        VerifierQueryEvent queryEvent = (VerifierQueryEvent)event;
        this.out.println(String.format("%s: %s", queryEvent.getName(), queryEvent.getStatus()));
    }
}

