/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.checksum.SimpleColumnChecksum;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SimpleColumnValidator
implements ColumnValidator {
    @Override
    public List<SingleColumn> generateChecksumColumns(Column column) {
        return ImmutableList.of((Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)column.getExpression())), Optional.of(VerifierUtil.delimitedIdentifier(SimpleColumnValidator.getChecksumColumnAlias(column)))));
    }

    public List<ColumnMatchResult<SimpleColumnChecksum>> validate(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        String checksumColumnAlias = SimpleColumnValidator.getChecksumColumnAlias(column);
        SimpleColumnChecksum controlChecksum = new SimpleColumnChecksum(controlResult.getChecksum(checksumColumnAlias));
        SimpleColumnChecksum testChecksum = new SimpleColumnChecksum(testResult.getChecksum(checksumColumnAlias));
        return ImmutableList.of(new ColumnMatchResult<SimpleColumnChecksum>(Objects.equals(controlChecksum, testChecksum), column, controlChecksum, testChecksum));
    }

    private static String getChecksumColumnAlias(Column column) {
        return column.getName() + "$checksum";
    }
}

