/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpClientBinder;
import com.facebook.presto.verifier.annotation.ForControl;
import com.facebook.presto.verifier.annotation.ForTest;
import com.facebook.presto.verifier.prestoaction.HttpNodeResourceClient;
import com.facebook.presto.verifier.prestoaction.NodeResourceClient;
import com.facebook.presto.verifier.prestoaction.PrestoActionFactory;
import com.facebook.presto.verifier.prestoaction.PrestoClusterConfig;
import com.facebook.presto.verifier.prestoaction.RoutingPrestoActionFactory;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.retry.ForClusterConnection;
import com.facebook.presto.verifier.retry.RetryConfig;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.util.Objects;

public class VerificationPrestoActionModule
implements Module {
    private final SqlExceptionClassifier exceptionClassifier;

    public VerificationPrestoActionModule(SqlExceptionClassifier exceptionClassifier) {
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
    }

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(PrestoClusterConfig.class, ForControl.class, "control");
        ConfigBinder.configBinder((Binder)binder).bindConfig(PrestoClusterConfig.class, ForTest.class, "test");
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("test", ForTest.class);
        binder.bind(PrestoActionFactory.class).to(RoutingPrestoActionFactory.class).in(Scopes.SINGLETON);
        binder.bind(SqlExceptionClassifier.class).toInstance((Object)this.exceptionClassifier);
    }

    @Provides
    @ForTest
    @Singleton
    public NodeResourceClient providesTestHttpPrestoResourceClient(@ForTest HttpClient httpClient, @ForTest PrestoClusterConfig prestoClusterConfig, @ForClusterConnection RetryConfig networkRetryConfig) {
        return new HttpNodeResourceClient(httpClient, prestoClusterConfig, networkRetryConfig);
    }
}

