/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.presto.verifier.annotation.ForControl;
import com.facebook.presto.verifier.annotation.ForTest;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.prestoaction.JdbcPrestoAction;
import com.facebook.presto.verifier.prestoaction.PrestoActionFactory;
import com.facebook.presto.verifier.prestoaction.PrestoClusterConfig;
import com.facebook.presto.verifier.prestoaction.RoutingPrestoAction;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.retry.ForClusterConnection;
import com.facebook.presto.verifier.retry.ForPresto;
import com.facebook.presto.verifier.retry.RetryConfig;
import java.util.Objects;
import javax.inject.Inject;

public class RoutingPrestoActionFactory
implements PrestoActionFactory {
    private final SqlExceptionClassifier exceptionClassifier;
    private final PrestoClusterConfig controlClusterConfig;
    private final PrestoClusterConfig testClusterConfig;
    private final RetryConfig networkRetryConfig;
    private final RetryConfig prestoRetryConfig;

    @Inject
    public RoutingPrestoActionFactory(SqlExceptionClassifier exceptionClassifier, @ForControl PrestoClusterConfig controlClusterConfig, @ForTest PrestoClusterConfig testClusterConfig, @ForClusterConnection RetryConfig networkRetryConfig, @ForPresto RetryConfig prestoRetryConfig) {
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.controlClusterConfig = Objects.requireNonNull(controlClusterConfig, "controlClusterConfig is null");
        this.testClusterConfig = Objects.requireNonNull(testClusterConfig, "testClusterConfig is null");
        this.networkRetryConfig = Objects.requireNonNull(networkRetryConfig, "networkRetryConfig is null");
        this.prestoRetryConfig = Objects.requireNonNull(prestoRetryConfig, "verifierConfig is null");
    }

    @Override
    public RoutingPrestoAction create(SourceQuery sourceQuery, VerificationContext verificationContext) {
        return new RoutingPrestoAction(new JdbcPrestoAction(this.exceptionClassifier, sourceQuery.getControlConfiguration(), verificationContext, this.controlClusterConfig, this.networkRetryConfig, this.prestoRetryConfig), new JdbcPrestoAction(this.exceptionClassifier, sourceQuery.getTestConfiguration(), verificationContext, this.testClusterConfig, this.networkRetryConfig, this.prestoRetryConfig));
    }
}

