/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import java.net.URI;
import java.util.Map;
import java.util.stream.Collectors;

public interface PrestoAddress {
    public String getHost();

    public int getJdbcPort();

    public int getHttpPort();

    public Map<String, String> getJdbcUrlParameters();

    default public String getJdbcUrl() {
        String query = this.getJdbcUrlParameters().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        return String.format("jdbc:presto://%s:%s?%s", this.getHost(), this.getJdbcPort(), query);
    }

    default public URI getHttpUri(String path) {
        return URI.create(String.format("http://%s:%s", this.getHost(), this.getHttpPort())).resolve(path);
    }
}

