/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.presto.jdbc.PrestoConnection;
import com.facebook.presto.jdbc.PrestoStatement;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.framework.ClusterConnectionException;
import com.facebook.presto.verifier.framework.PrestoQueryException;
import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.prestoaction.PrestoClusterConfig;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.retry.ForClusterConnection;
import com.facebook.presto.verifier.retry.ForPresto;
import com.facebook.presto.verifier.retry.RetryConfig;
import com.facebook.presto.verifier.retry.RetryDriver;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class JdbcPrestoAction
implements PrestoAction {
    private static final String QUERY_MAX_EXECUTION_TIME = "query_max_execution_time";
    private final SqlExceptionClassifier exceptionClassifier;
    private final QueryConfiguration queryConfiguration;
    private final String jdbcUrl;
    private final Duration queryTimeout;
    private final Duration metadataTimeout;
    private final Duration checksumTimeout;
    private final RetryDriver<QueryException> networkRetry;
    private final RetryDriver<QueryException> prestoRetry;

    public JdbcPrestoAction(SqlExceptionClassifier exceptionClassifier, QueryConfiguration queryConfiguration, VerificationContext verificationContext, PrestoClusterConfig prestoClusterConfig, @ForClusterConnection RetryConfig networkRetryConfig, @ForPresto RetryConfig prestoRetryConfig) {
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.queryConfiguration = Objects.requireNonNull(queryConfiguration, "queryConfiguration is null");
        this.jdbcUrl = Objects.requireNonNull(prestoClusterConfig.getJdbcUrl(), "jdbcUrl is null");
        this.queryTimeout = Objects.requireNonNull(prestoClusterConfig.getQueryTimeout(), "queryTimeout is null");
        this.metadataTimeout = Objects.requireNonNull(prestoClusterConfig.getMetadataTimeout(), "metadataTimeout is null");
        this.checksumTimeout = Objects.requireNonNull(prestoClusterConfig.getChecksumTimeout(), "checksumTimeout is null");
        this.networkRetry = new RetryDriver<QueryException>(networkRetryConfig, queryException -> queryException instanceof ClusterConnectionException && queryException.isRetryable(), QueryException.class, verificationContext::addException);
        this.prestoRetry = new RetryDriver<QueryException>(prestoRetryConfig, queryException -> queryException instanceof PrestoQueryException && queryException.isRetryable(), QueryException.class, verificationContext::addException);
    }

    @Override
    public QueryStats execute(Statement statement, QueryStage queryStage) {
        return this.execute(statement, queryStage, new NoResultStatementExecutor());
    }

    @Override
    public <R> QueryResult<R> execute(Statement statement, QueryStage queryStage, PrestoAction.ResultSetConverter<R> converter) {
        return (QueryResult)this.execute(statement, queryStage, new ResultConvertingStatementExecutor<R>(converter));
    }

    private <T> T execute(Statement statement, QueryStage queryStage, StatementExecutor<T> statementExecutor) {
        return (T)this.prestoRetry.run("presto", () -> this.networkRetry.run("presto-cluster-connection", () -> this.executeOnce(statement, queryStage, statementExecutor)));
    }

    /*
     * Exception decompiling
     */
    private <T> T executeOnce(Statement statement, QueryStage queryStage, StatementExecutor<T> statementExecutor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PrestoConnection getConnection(QueryStage queryStage) throws SQLException {
        PrestoConnection connection = DriverManager.getConnection(this.jdbcUrl, this.queryConfiguration.getUsername().orElse(null), this.queryConfiguration.getPassword().orElse(null)).unwrap(PrestoConnection.class);
        try {
            connection.setClientInfo("ApplicationName", "verifier-test");
            connection.setCatalog(this.queryConfiguration.getCatalog());
            connection.setSchema(this.queryConfiguration.getSchema());
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            // empty catch block
        }
        HashMap<String, String> sessionProperties = new HashMap<String, String>(this.queryConfiguration.getSessionProperties());
        sessionProperties.put(QUERY_MAX_EXECUTION_TIME, this.getTimeout(queryStage).toString());
        for (Map.Entry entry : sessionProperties.entrySet()) {
            connection.setSessionProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return connection;
    }

    private Duration getTimeout(QueryStage queryStage) {
        switch (queryStage) {
            case REWRITE: 
            case DESCRIBE: {
                return this.metadataTimeout;
            }
            case CONTROL_CHECKSUM: 
            case TEST_CHECKSUM: 
            case DETERMINISM_ANALYSIS_CHECKSUM: {
                return this.checksumTimeout;
            }
        }
        return this.queryTimeout;
    }

    private static class NoResultStatementExecutor<R>
    implements StatementExecutor<QueryStats> {
        private final ProgressMonitor progressMonitor = new ProgressMonitor();

        private NoResultStatementExecutor() {
        }

        @Override
        public QueryStats execute(PrestoStatement statement, String query) throws SQLException {
            boolean moreResults = statement.execute(query);
            if (moreResults) {
                NoResultStatementExecutor.consumeResultSet(statement.getResultSet());
            }
            do {
                if (!(moreResults = statement.getMoreResults())) continue;
                NoResultStatementExecutor.consumeResultSet(statement.getResultSet());
            } while (moreResults || statement.getUpdateCount() != -1);
            Preconditions.checkState((boolean)this.progressMonitor.getLastQueryStats().isPresent(), (Object)"lastQueryStats is missing");
            return this.progressMonitor.getLastQueryStats().get();
        }

        @Override
        public ProgressMonitor getProgressMonitor() {
            return this.progressMonitor;
        }

        private static void consumeResultSet(ResultSet resultSet) throws SQLException {
            while (resultSet.next()) {
            }
        }
    }

    private static class ResultConvertingStatementExecutor<R>
    implements StatementExecutor<QueryResult<R>> {
        private final PrestoAction.ResultSetConverter<R> converter;
        private final ProgressMonitor progressMonitor = new ProgressMonitor();

        public ResultConvertingStatementExecutor(PrestoAction.ResultSetConverter<R> converter) {
            this.converter = Objects.requireNonNull(converter, "converter is null");
        }

        @Override
        public QueryResult<R> execute(PrestoStatement statement, String query) throws SQLException {
            ImmutableList.Builder rows = ImmutableList.builder();
            try (ResultSet resultSet = statement.executeQuery(query);){
                while (resultSet.next()) {
                    this.converter.apply(resultSet).ifPresent(arg_0 -> ((ImmutableList.Builder)rows).add(arg_0));
                }
                Preconditions.checkState((boolean)this.progressMonitor.getLastQueryStats().isPresent(), (Object)"lastQueryStats is missing");
                QueryResult queryResult = new QueryResult(rows.build(), resultSet.getMetaData(), this.progressMonitor.getLastQueryStats().get());
                return queryResult;
            }
        }

        @Override
        public ProgressMonitor getProgressMonitor() {
            return this.progressMonitor;
        }
    }

    private static interface StatementExecutor<T> {
        public T execute(PrestoStatement var1, String var2) throws SQLException;

        public ProgressMonitor getProgressMonitor();
    }

    private static class ProgressMonitor
    implements Consumer<QueryStats> {
        private Optional<QueryStats> queryStats = Optional.empty();

        private ProgressMonitor() {
        }

        @Override
        public synchronized void accept(QueryStats queryStats) {
            this.queryStats = Optional.of(Objects.requireNonNull(queryStats, "queryStats is null"));
        }

        public synchronized Optional<QueryStats> getLastQueryStats() {
            return this.queryStats;
        }
    }
}

