/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.StringResponseHandler;
import com.facebook.airlift.json.ObjectMapperProvider;
import com.facebook.presto.verifier.prestoaction.NodeResourceClient;
import com.facebook.presto.verifier.prestoaction.PrestoAddress;
import com.facebook.presto.verifier.prestoaction.PrestoClusterConfig;
import com.facebook.presto.verifier.prestoaction.PrestoExceptionClassifier;
import com.facebook.presto.verifier.retry.RetryConfig;
import com.facebook.presto.verifier.retry.RetryDriver;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Response;

public class HttpNodeResourceClient
implements NodeResourceClient {
    private final HttpClient httpClient;
    private final PrestoAddress prestoAddress;
    private final RetryDriver<RuntimeException> networkRetry;

    @Inject
    public HttpNodeResourceClient(HttpClient httpClient, PrestoClusterConfig prestoAddress, RetryConfig networkRetryConfig) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.prestoAddress = Objects.requireNonNull(prestoAddress, "prestoAddress is null");
        this.networkRetry = new RetryDriver<RuntimeException>(networkRetryConfig, PrestoExceptionClassifier::isClusterConnectionException, RuntimeException.class, e -> {});
    }

    @Override
    public int getClusterSize(String path) {
        return this.networkRetry.run(String.format("getJsonResponse()", path), () -> this.getClusterSizeOnce(path));
    }

    private int getClusterSizeOnce(String path) {
        List values;
        Request request = Request.Builder.prepareGet().setUri(this.prestoAddress.getHttpUri(path)).setHeader("Content-Type", "application/json").build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.httpClient.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Preconditions.checkState((response.getStatusCode() == Response.Status.OK.getStatusCode() ? 1 : 0) != 0, (String)"Invalid response: %s %s", (int)response.getStatusCode(), (Object)response.getStatusMessage());
        try {
            values = (List)new ObjectMapperProvider().get().readValue(response.getBody(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return values.size();
    }
}

