/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.verifier.framework.QueryConfiguration;
import java.util.Objects;
import org.jdbi.v3.core.mapper.Nested;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;

public class SourceQuery {
    private final String suite;
    private final String name;
    private final String controlQuery;
    private final String testQuery;
    private final QueryConfiguration controlConfiguration;
    private final QueryConfiguration testConfiguration;

    @JdbiConstructor
    public SourceQuery(@ColumnName(value="suite") String suite, @ColumnName(value="name") String name, @ColumnName(value="controlQuery") String controlQuery, @ColumnName(value="testQuery") String testQuery, @Nested(value="control") QueryConfiguration controlConfiguration, @Nested(value="test") QueryConfiguration testConfiguration) {
        this.suite = Objects.requireNonNull(suite, "suite is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.controlQuery = SourceQuery.clean(controlQuery);
        this.testQuery = SourceQuery.clean(testQuery);
        this.controlConfiguration = Objects.requireNonNull(controlConfiguration, "controlConfiguration is null");
        this.testConfiguration = Objects.requireNonNull(testConfiguration, "testConfiguration is null");
    }

    public String getSuite() {
        return this.suite;
    }

    public String getName() {
        return this.name;
    }

    public String getControlQuery() {
        return this.controlQuery;
    }

    public String getTestQuery() {
        return this.testQuery;
    }

    public QueryConfiguration getControlConfiguration() {
        return this.controlConfiguration;
    }

    public QueryConfiguration getTestConfiguration() {
        return this.testConfiguration;
    }

    private static String clean(String sql) {
        sql = sql.replaceAll("\t", "  ");
        sql = sql.replaceAll("\n+", "\n");
        sql = sql.trim();
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        return sql;
    }
}

