/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.verifier.event.QueryFailure;
import com.facebook.presto.verifier.framework.PrestoQueryException;
import com.facebook.presto.verifier.framework.QueryStage;
import com.google.common.base.Throwables;
import java.util.Objects;
import java.util.Optional;

public abstract class QueryException
extends RuntimeException {
    private final boolean retryable;
    private final QueryStage queryStage;

    public QueryException(Throwable cause, boolean retryable, QueryStage queryStage) {
        super(cause);
        this.retryable = retryable;
        this.queryStage = Objects.requireNonNull(queryStage, "queryStage is null");
    }

    public abstract String getErrorCodeName();

    public boolean isRetryable() {
        return this.retryable;
    }

    public QueryStage getQueryStage() {
        return this.queryStage;
    }

    public QueryFailure toQueryFailure() {
        return new QueryFailure(this.queryStage, this.getErrorCodeName(), this instanceof PrestoQueryException ? ((PrestoQueryException)this).getErrorCode().map(ErrorCodeSupplier::toErrorCode).map(ErrorCode::getType) : Optional.empty(), this.retryable, this instanceof PrestoQueryException ? ((PrestoQueryException)this).getQueryStats().map(QueryStats::getQueryId) : Optional.empty(), Throwables.getStackTraceAsString((Throwable)this));
    }
}

