/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.framework.ClusterType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class QueryBundle {
    private final QualifiedName tableName;
    private final List<Statement> setupQueries;
    private final Statement query;
    private final List<Statement> teardownQueries;
    private final ClusterType cluster;

    public QueryBundle(QualifiedName tableName, List<Statement> setupQueries, Statement query, List<Statement> teardownQueries, ClusterType cluster) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.setupQueries = ImmutableList.copyOf(setupQueries);
        this.query = Objects.requireNonNull(query, "query is null");
        this.teardownQueries = ImmutableList.copyOf(teardownQueries);
        this.cluster = Objects.requireNonNull(cluster, "cluster is null");
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public List<Statement> getSetupQueries() {
        return this.setupQueries;
    }

    public Statement getQuery() {
        return this.query;
    }

    public List<Statement> getTeardownQueries() {
        return this.teardownQueries;
    }

    public ClusterType getCluster() {
        return this.cluster;
    }
}

