/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryStage;
import java.util.Objects;
import java.util.Optional;

public class PrestoQueryException
extends QueryException {
    private final Optional<ErrorCodeSupplier> errorCode;
    private final Optional<QueryStats> queryStats;

    public PrestoQueryException(Throwable cause, boolean retryable, QueryStage queryStage, Optional<ErrorCodeSupplier> errorCode, Optional<QueryStats> queryStats) {
        super(cause, retryable, queryStage);
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null");
        this.queryStats = Objects.requireNonNull(queryStats, "queryStats is null");
    }

    public Optional<ErrorCodeSupplier> getErrorCode() {
        return this.errorCode;
    }

    public Optional<QueryStats> getQueryStats() {
        return this.queryStats;
    }

    @Override
    public String getErrorCodeName() {
        return String.format("PRESTO(%s)", this.errorCode.map(ErrorCodeSupplier::toErrorCode).map(ErrorCode::getName).orElse("UNKNOWN"));
    }
}

