/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.event.DeterminismAnalysisDetails;
import com.facebook.presto.verifier.event.QueryInfo;
import com.facebook.presto.verifier.event.VerifierQueryEvent;
import com.facebook.presto.verifier.framework.ChecksumQueryContext;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.DataVerificationUtil;
import com.facebook.presto.verifier.framework.DeterminismAnalysis;
import com.facebook.presto.verifier.framework.DeterminismAnalyzer;
import com.facebook.presto.verifier.framework.MatchResult;
import com.facebook.presto.verifier.framework.PrestoQueryException;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.QueryState;
import com.facebook.presto.verifier.framework.SkippedReason;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.Verification;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerificationResult;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.resolver.FailureResolverManager;
import com.facebook.presto.verifier.rewrite.QueryRewriter;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public abstract class AbstractVerification
implements Verification {
    private static final String INTERNAL_ERROR = "VERIFIER_INTERNAL_ERROR";
    private final PrestoAction prestoAction;
    private final SourceQuery sourceQuery;
    private final QueryRewriter queryRewriter;
    private final DeterminismAnalyzer determinismAnalyzer;
    private final FailureResolverManager failureResolverManager;
    private final SqlExceptionClassifier exceptionClassifier;
    private final VerificationContext verificationContext;
    private final String testId;
    private final boolean smartTeardown;
    private final int verificationResubmissionLimit;

    public AbstractVerification(PrestoAction prestoAction, SourceQuery sourceQuery, QueryRewriter queryRewriter, DeterminismAnalyzer determinismAnalyzer, FailureResolverManager failureResolverManager, SqlExceptionClassifier exceptionClassifier, VerificationContext verificationContext, VerifierConfig verifierConfig) {
        this.prestoAction = Objects.requireNonNull(prestoAction, "prestoAction is null");
        this.sourceQuery = Objects.requireNonNull(sourceQuery, "sourceQuery is null");
        this.queryRewriter = Objects.requireNonNull(queryRewriter, "queryRewriter is null");
        this.determinismAnalyzer = Objects.requireNonNull(determinismAnalyzer, "determinismAnalyzer is null");
        this.failureResolverManager = Objects.requireNonNull(failureResolverManager, "failureResolverManager is null");
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.verificationContext = Objects.requireNonNull(verificationContext, "verificationContext is null");
        this.testId = Objects.requireNonNull(verifierConfig.getTestId(), "testId is null");
        this.smartTeardown = verifierConfig.isSmartTeardown();
        this.verificationResubmissionLimit = verifierConfig.getVerificationResubmissionLimit();
    }

    protected abstract MatchResult verify(QueryBundle var1, QueryBundle var2, ChecksumQueryContext var3, ChecksumQueryContext var4);

    protected PrestoAction getPrestoAction() {
        return this.prestoAction;
    }

    @Override
    public SourceQuery getSourceQuery() {
        return this.sourceQuery;
    }

    @Override
    public VerificationContext getVerificationContext() {
        return this.verificationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerificationResult run() {
        Optional<QueryBundle> control = Optional.empty();
        Optional<QueryBundle> test = Optional.empty();
        QueryContext controlQueryContext = new QueryContext();
        QueryContext testQueryContext = new QueryContext();
        ChecksumQueryContext controlChecksumQueryContext = new ChecksumQueryContext();
        ChecksumQueryContext testChecksumQueryContext = new ChecksumQueryContext();
        Optional<MatchResult> matchResult = Optional.empty();
        Optional<DeterminismAnalysis> determinismAnalysis = Optional.empty();
        DeterminismAnalysisDetails.Builder determinismAnalysisDetails = DeterminismAnalysisDetails.builder();
        Optional<Object> partialResult = Optional.empty();
        Optional<Throwable> throwable = Optional.empty();
        try {
            control = Optional.of(this.queryRewriter.rewriteQuery(this.sourceQuery.getControlQuery(), ClusterType.CONTROL));
            test = Optional.of(this.queryRewriter.rewriteQuery(this.sourceQuery.getTestQuery(), ClusterType.TEST));
            QueryBundle controlQueryBundle = control.get();
            QueryBundle testQueryBundle = test.get();
            controlQueryBundle.getSetupQueries().forEach(query -> VerifierUtil.runAndConsume(() -> this.prestoAction.execute((Statement)query, QueryStage.CONTROL_SETUP), controlQueryContext::addSetupQuery, controlQueryContext::setException));
            VerifierUtil.runAndConsume(() -> this.prestoAction.execute(controlQueryBundle.getQuery(), QueryStage.CONTROL_MAIN), controlQueryContext::setMainQueryStats, controlQueryContext::setException);
            controlQueryContext.setState(QueryState.SUCCEEDED);
            testQueryBundle.getSetupQueries().forEach(query -> VerifierUtil.runAndConsume(() -> this.prestoAction.execute((Statement)query, QueryStage.TEST_SETUP), testQueryContext::addSetupQuery, testQueryContext::setException));
            VerifierUtil.runAndConsume(() -> this.prestoAction.execute(testQueryBundle.getQuery(), QueryStage.TEST_MAIN), testQueryContext::setMainQueryStats, testQueryContext::setException);
            testQueryContext.setState(QueryState.SUCCEEDED);
            matchResult = Optional.of(this.verify(controlQueryBundle, test.get(), controlChecksumQueryContext, testChecksumQueryContext));
            if (matchResult.get().isMismatchPossiblyCausedByNonDeterminism()) {
                determinismAnalysis = Optional.of(this.determinismAnalyzer.analyze(controlQueryBundle, matchResult.get().getControlChecksum(), determinismAnalysisDetails));
            }
            partialResult = Optional.of(this.concludeVerificationPartial(control, test, controlQueryContext, matchResult, determinismAnalysis, Optional.empty()));
        }
        catch (Throwable t) {
            if (this.exceptionClassifier.shouldResubmit(t) && this.verificationContext.getResubmissionCount() < this.verificationResubmissionLimit) {
                VerificationResult verificationResult = new VerificationResult(this, true, Optional.empty());
                return verificationResult;
            }
            throwable = Optional.of(t);
            partialResult = Optional.of(this.concludeVerificationPartial(control, test, controlQueryContext, matchResult, determinismAnalysis, Optional.of(t)));
        }
        finally {
            block13: {
                block12: {
                    if (!this.smartTeardown || testQueryContext.getState() != QueryState.SUCCEEDED) break block12;
                    if (!partialResult.isPresent() || !((PartialVerificationResult)partialResult.get()).getStatus().equals((Object)VerifierQueryEvent.EventStatus.SUCCEEDED)) break block13;
                }
                DataVerificationUtil.teardownSafely(this.prestoAction, control, controlQueryContext::addTeardownQuery);
                DataVerificationUtil.teardownSafely(this.prestoAction, test, testQueryContext::addTeardownQuery);
            }
        }
        return this.concludeVerification((PartialVerificationResult)partialResult.get(), control, test, controlQueryContext, testQueryContext, matchResult, determinismAnalysis, controlChecksumQueryContext, testChecksumQueryContext, determinismAnalysisDetails.build(), throwable);
    }

    private Optional<String> resolveFailure(Optional<QueryBundle> control, Optional<QueryBundle> test, QueryContext controlQueryContext, Optional<MatchResult> matchResult, Optional<Throwable> throwable) {
        if (matchResult.isPresent() && !matchResult.get().isMatched()) {
            Preconditions.checkState((boolean)control.isPresent(), (Object)"control is missing");
            return this.failureResolverManager.resolveResultMismatch(matchResult.get(), control.get());
        }
        if (throwable.isPresent() && controlQueryContext.getState() == QueryState.SUCCEEDED) {
            Preconditions.checkState((boolean)controlQueryContext.getMainQueryStats().isPresent(), (Object)"controlQueryStats is missing");
            return this.failureResolverManager.resolveException(controlQueryContext.getMainQueryStats().get(), throwable.get(), test);
        }
        return Optional.empty();
    }

    private VerifierQueryEvent.EventStatus getEventStatus(Optional<SkippedReason> skippedReason, Optional<String> resolveMessage, Optional<MatchResult> matchResult) {
        if (skippedReason.isPresent()) {
            return VerifierQueryEvent.EventStatus.SKIPPED;
        }
        if (resolveMessage.isPresent()) {
            return VerifierQueryEvent.EventStatus.FAILED_RESOLVED;
        }
        if (matchResult.isPresent() && matchResult.get().isMatched()) {
            return VerifierQueryEvent.EventStatus.SUCCEEDED;
        }
        return VerifierQueryEvent.EventStatus.FAILED;
    }

    private PartialVerificationResult concludeVerificationPartial(Optional<QueryBundle> control, Optional<QueryBundle> test, QueryContext controlQueryContext, Optional<MatchResult> matchResult, Optional<DeterminismAnalysis> determinismAnalysis, Optional<Throwable> throwable) {
        Optional<SkippedReason> skippedReason = this.getSkippedReason(throwable, controlQueryContext.getState(), determinismAnalysis);
        Optional<String> resolveMessage = this.resolveFailure(control, test, controlQueryContext, matchResult, throwable);
        VerifierQueryEvent.EventStatus status = this.getEventStatus(skippedReason, resolveMessage, matchResult);
        return new PartialVerificationResult(skippedReason, resolveMessage, status);
    }

    private VerificationResult concludeVerification(PartialVerificationResult partialResult, Optional<QueryBundle> control, Optional<QueryBundle> test, QueryContext controlQueryContext, QueryContext testQueryContext, Optional<MatchResult> matchResult, Optional<DeterminismAnalysis> determinismAnalysis, ChecksumQueryContext controlChecksumQueryContext, ChecksumQueryContext testChecksumQueryContext, DeterminismAnalysisDetails determinismAnalysisDetails, Optional<Throwable> throwable) {
        Optional<String> errorCode = Optional.empty();
        Optional<String> errorMessage = Optional.empty();
        if (partialResult.getStatus() != VerifierQueryEvent.EventStatus.SUCCEEDED) {
            errorCode = Optional.ofNullable(throwable.map(t -> t instanceof QueryException ? ((QueryException)t).getErrorCodeName() : INTERNAL_ERROR).orElse(matchResult.map(MatchResult::getMatchType).map(Enum::name).orElse(null)));
            errorMessage = Optional.of(this.constructErrorMessage(throwable, matchResult, controlQueryContext.getState(), testQueryContext.getState()));
        }
        VerifierQueryEvent event = new VerifierQueryEvent(this.sourceQuery.getSuite(), this.testId, this.sourceQuery.getName(), partialResult.getStatus(), partialResult.getSkippedReason(), determinismAnalysis, determinismAnalysis.isPresent() ? Optional.of(determinismAnalysisDetails) : Optional.empty(), partialResult.getResolveMessage(), AbstractVerification.buildQueryInfo(this.sourceQuery.getControlConfiguration(), this.sourceQuery.getControlQuery(), controlChecksumQueryContext, control, controlQueryContext), AbstractVerification.buildQueryInfo(this.sourceQuery.getTestConfiguration(), this.sourceQuery.getTestQuery(), testChecksumQueryContext, test, testQueryContext), errorCode, errorMessage, throwable.filter(QueryException.class::isInstance).map(QueryException.class::cast).map(QueryException::toQueryFailure), this.verificationContext.getQueryFailures(), this.verificationContext.getResubmissionCount());
        return new VerificationResult(this, false, Optional.of(event));
    }

    private static QueryInfo buildQueryInfo(QueryConfiguration configuration, String originalQuery, ChecksumQueryContext checksumQueryContext, Optional<QueryBundle> queryBundle, QueryContext queryContext) {
        return new QueryInfo(configuration.getCatalog(), configuration.getSchema(), originalQuery, queryContext.getMainQueryStats().map(QueryStats::getQueryId), queryContext.getSetupQueryIds(), queryContext.getTeardownQueryIds(), checksumQueryContext.getChecksumQueryId(), queryBundle.map(QueryBundle::getQuery).map(AbstractVerification::formatSql), queryBundle.map(QueryBundle::getSetupQueries).map(AbstractVerification::formatSqls), queryBundle.map(QueryBundle::getTeardownQueries).map(AbstractVerification::formatSqls), checksumQueryContext.getChecksumQuery(), AbstractVerification.millisToSeconds(queryContext.getMainQueryStats().map(QueryStats::getCpuTimeMillis)), AbstractVerification.millisToSeconds(queryContext.getMainQueryStats().map(QueryStats::getWallTimeMillis)), queryContext.getMainQueryStats().map(QueryStats::getPeakTotalMemoryBytes));
    }

    protected static String formatSql(Statement statement) {
        return SqlFormatter.formatSql((Node)statement, Optional.empty());
    }

    protected static List<String> formatSqls(List<Statement> statements) {
        return (List)statements.stream().map(AbstractVerification::formatSql).collect(ImmutableList.toImmutableList());
    }

    private Optional<SkippedReason> getSkippedReason(Optional<Throwable> throwable, QueryState controlState, Optional<DeterminismAnalysis> determinismAnalysis) {
        if (throwable.isPresent() && !(throwable.get() instanceof QueryException)) {
            return Optional.of(SkippedReason.VERIFIER_INTERNAL_ERROR);
        }
        switch (controlState) {
            case FAILED: {
                return Optional.of(SkippedReason.CONTROL_QUERY_FAILED);
            }
            case FAILED_TO_SETUP: {
                return Optional.of(SkippedReason.CONTROL_SETUP_QUERY_FAILED);
            }
            case TIMED_OUT: {
                return Optional.of(SkippedReason.CONTROL_QUERY_TIMED_OUT);
            }
            case NOT_RUN: {
                return Optional.of(SkippedReason.FAILED_BEFORE_CONTROL_QUERY);
            }
        }
        if (determinismAnalysis.isPresent() && determinismAnalysis.get().isNonDeterministic()) {
            return Optional.of(SkippedReason.NON_DETERMINISTIC);
        }
        return Optional.empty();
    }

    private static Optional<Double> millisToSeconds(Optional<Long> millis) {
        return millis.map(value -> new Duration((double)value.longValue(), TimeUnit.MILLISECONDS).getValue(TimeUnit.SECONDS));
    }

    private static QueryState getFailingQueryState(QueryException queryException) {
        QueryStage queryStage = queryException.getQueryStage();
        Preconditions.checkArgument((queryStage.isSetup() || queryStage.isMain() ? 1 : 0) != 0, (String)"Expect QueryStage SETUP or MAIN: %s", (Object)((Object)queryStage));
        if (queryStage.isSetup()) {
            return QueryState.FAILED_TO_SETUP;
        }
        return queryException instanceof PrestoQueryException && ((PrestoQueryException)queryException).getErrorCode().equals(Optional.of(StandardErrorCode.EXCEEDED_TIME_LIMIT)) ? QueryState.TIMED_OUT : QueryState.FAILED;
    }

    private String constructErrorMessage(Optional<Throwable> throwable, Optional<MatchResult> matchResult, QueryState controlState, QueryState testState) {
        StringBuilder message = new StringBuilder(String.format("Test state %s, Control state %s.\n\n", new Object[]{testState, controlState}));
        if (throwable.isPresent()) {
            if (throwable.get() instanceof PrestoQueryException) {
                PrestoQueryException exception = (PrestoQueryException)throwable.get();
                message.append(exception.getQueryStage().name().replace("_", " ")).append(" query failed on ").append((Object)exception.getQueryStage().getTargetCluster()).append(" cluster:\n").append(Throwables.getStackTraceAsString((Throwable)exception.getCause()));
            } else {
                message.append(Throwables.getStackTraceAsString((Throwable)throwable.get()));
            }
        }
        matchResult.ifPresent(result -> message.append(result.getResultsComparison()));
        return message.toString();
    }

    private static class PartialVerificationResult {
        private final Optional<SkippedReason> skippedReason;
        private final Optional<String> resolveMessage;
        private final VerifierQueryEvent.EventStatus status;

        public PartialVerificationResult(Optional<SkippedReason> skippedReason, Optional<String> resolveMessage, VerifierQueryEvent.EventStatus status) {
            this.skippedReason = Objects.requireNonNull(skippedReason, "skippedReason is null");
            this.resolveMessage = Objects.requireNonNull(resolveMessage, "resolveMessage is null");
            this.status = Objects.requireNonNull(status, "status is null");
        }

        public Optional<SkippedReason> getSkippedReason() {
            return this.skippedReason;
        }

        public Optional<String> getResolveMessage() {
            return this.resolveMessage;
        }

        public VerifierQueryEvent.EventStatus getStatus() {
            return this.status;
        }
    }

    private static class QueryContext {
        private Optional<QueryStats> mainQueryStats = Optional.empty();
        private Optional<QueryState> state = Optional.empty();
        private ImmutableList.Builder<String> setupQueryIds = ImmutableList.builder();
        private ImmutableList.Builder<String> teardownQueryIds = ImmutableList.builder();

        private QueryContext() {
        }

        public Optional<QueryStats> getMainQueryStats() {
            return this.mainQueryStats;
        }

        public void setMainQueryStats(QueryStats mainQueryStats) {
            Preconditions.checkState((!this.mainQueryStats.isPresent() ? 1 : 0) != 0, (String)"mainQueryStats is already set", (Object)mainQueryStats);
            this.mainQueryStats = Optional.of(mainQueryStats);
        }

        public QueryState getState() {
            return this.state.orElse(QueryState.NOT_RUN);
        }

        public void setState(QueryState state) {
            Preconditions.checkState((!this.state.isPresent() ? 1 : 0) != 0, (String)"state is already set", (Object)((Object)state));
            this.state = Optional.of(state);
        }

        public void setException(QueryException e) {
            this.setState(AbstractVerification.getFailingQueryState(e));
        }

        public List<String> getSetupQueryIds() {
            return this.setupQueryIds.build();
        }

        public void addSetupQuery(QueryStats queryStats) {
            this.setupQueryIds.add((Object)queryStats.getQueryId());
        }

        public List<String> getTeardownQueryIds() {
            return this.teardownQueryIds.build();
        }

        public void addTeardownQuery(QueryStats queryStats) {
            this.teardownQueryIds.add((Object)queryStats.getQueryId());
        }
    }
}

