/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.event;

import com.facebook.airlift.event.client.EventField;
import com.facebook.airlift.event.client.EventType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@EventType(value="QueryInfo")
@Immutable
public class QueryInfo {
    private final String catalog;
    private final String schema;
    private final String originalQuery;
    private final String queryId;
    private final List<String> setupQueryIds;
    private final List<String> teardownQueryIds;
    private final String checksumQueryId;
    private final String query;
    private final List<String> setupQueries;
    private final List<String> teardownQueries;
    private final String checksumQuery;
    private final Double cpuTimeSecs;
    private final Double wallTimeSecs;
    private final Long peakTotalMemoryBytes;

    public QueryInfo(String catalog, String schema, String originalQuery) {
        this(catalog, schema, originalQuery, Optional.empty(), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public QueryInfo(String catalog, String schema, String originalQuery, Optional<String> queryId, List<String> setupQueryIds, List<String> teardownQueryIds, Optional<String> checksumQueryId, Optional<String> query, Optional<List<String>> setupQueries, Optional<List<String>> teardownQueries, Optional<String> checksumQuery, Optional<Double> cpuTimeSecs, Optional<Double> wallTimeSecs, Optional<Long> peakTotalMemoryBytes) {
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.originalQuery = Objects.requireNonNull(originalQuery, "originalQuery is null");
        this.queryId = queryId.orElse(null);
        this.setupQueryIds = ImmutableList.copyOf(setupQueryIds);
        this.teardownQueryIds = ImmutableList.copyOf(teardownQueryIds);
        this.checksumQueryId = checksumQueryId.orElse(null);
        this.query = query.orElse(null);
        this.setupQueries = setupQueries.orElse(null);
        this.teardownQueries = teardownQueries.orElse(null);
        this.checksumQuery = checksumQuery.orElse(null);
        this.cpuTimeSecs = cpuTimeSecs.orElse(null);
        this.wallTimeSecs = wallTimeSecs.orElse(null);
        this.peakTotalMemoryBytes = peakTotalMemoryBytes.orElse(null);
    }

    @EventField
    public String getCatalog() {
        return this.catalog;
    }

    @EventField
    public String getSchema() {
        return this.schema;
    }

    @EventField
    public String getOriginalQuery() {
        return this.originalQuery;
    }

    @EventField
    public String getQueryId() {
        return this.queryId;
    }

    @EventField
    public List<String> getSetupQueryIds() {
        return this.setupQueryIds;
    }

    @EventField
    public List<String> getTeardownQueryIds() {
        return this.teardownQueryIds;
    }

    @EventField
    public String getChecksumQueryId() {
        return this.checksumQueryId;
    }

    @EventField
    public String getQuery() {
        return this.query;
    }

    @EventField
    public List<String> getSetupQueries() {
        return this.setupQueries;
    }

    @EventField
    public List<String> getTeardownQueries() {
        return this.teardownQueries;
    }

    @EventField
    public String getChecksumQuery() {
        return this.checksumQuery;
    }

    @EventField
    public Double getCpuTimeSecs() {
        return this.cpuTimeSecs;
    }

    @EventField
    public Double getWallTimeSecs() {
        return this.wallTimeSecs;
    }

    @EventField
    public Long getPeakTotalMemoryBytes() {
        return this.peakTotalMemoryBytes;
    }
}

