/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.rewrite;

import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.verifier.annotation.ForControl;
import com.facebook.presto.verifier.annotation.ForTest;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.rewrite.QueryRewriteConfig;
import com.facebook.presto.verifier.rewrite.QueryRewriter;
import com.facebook.presto.verifier.rewrite.QueryRewriterFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class VerificationQueryRewriterFactory
implements QueryRewriterFactory {
    private final SqlParser sqlParser;
    private final TypeManager typeManager;
    private final QualifiedName controlTablePrefix;
    private final QualifiedName testTablePrefix;
    private final List<Property> controlTableProperties;
    private final List<Property> testTableProperties;

    @Inject
    public VerificationQueryRewriterFactory(SqlParser sqlParser, TypeManager typeManager, @ForControl QueryRewriteConfig controlConfig, @ForTest QueryRewriteConfig testConfig) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.controlTablePrefix = Objects.requireNonNull(controlConfig.getTablePrefix(), "controlTablePrefix is null");
        this.testTablePrefix = Objects.requireNonNull(testConfig.getTablePrefix(), "testTablePrefix is null");
        this.controlTableProperties = VerificationQueryRewriterFactory.constructProperties(controlConfig.getTableProperties());
        this.testTableProperties = VerificationQueryRewriterFactory.constructProperties(testConfig.getTableProperties());
    }

    @Override
    public QueryRewriter create(PrestoAction prestoAction) {
        return new QueryRewriter(this.sqlParser, this.typeManager, prestoAction, (Map<ClusterType, QualifiedName>)ImmutableMap.of((Object)((Object)ClusterType.CONTROL), (Object)this.controlTablePrefix, (Object)((Object)ClusterType.TEST), (Object)this.testTablePrefix), (Map<ClusterType, List<Property>>)ImmutableMap.of((Object)((Object)ClusterType.CONTROL), this.controlTableProperties, (Object)((Object)ClusterType.TEST), this.testTableProperties));
    }

    private static List<Property> constructProperties(Map<String, Object> propertiesMap) {
        ImmutableList.Builder properties = ImmutableList.builder();
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            if (entry.getValue() instanceof Integer || entry.getValue() instanceof Long) {
                properties.add((Object)new Property(new Identifier(entry.getKey()), (Expression)new LongLiteral(String.valueOf(entry.getValue()))));
                continue;
            }
            if (entry.getValue() instanceof Double) {
                properties.add((Object)new Property(new Identifier(entry.getKey()), (Expression)new DoubleLiteral(String.valueOf(entry.getValue()))));
                continue;
            }
            if (entry.getValue() instanceof String) {
                properties.add((Object)new Property(new Identifier(entry.getKey()), (Expression)new StringLiteral((String)entry.getValue())));
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                properties.add((Object)new Property(new Identifier(entry.getKey()), (Expression)((Boolean)entry.getValue() != false ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL)));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unsupported table properties value: %s = %s (type: %s)", entry.getKey(), entry.getValue(), entry.getValue().getClass()));
        }
        return properties.build();
    }
}

