/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.resolver.FailureResolver;
import com.facebook.presto.verifier.resolver.FailureResolverFactory;
import com.facebook.presto.verifier.resolver.FailureResolverFactoryContext;
import com.facebook.presto.verifier.resolver.FailureResolverUtil;
import java.util.Optional;

public class VerifierLimitationFailureResolver
implements FailureResolver {
    public static final String NAME = "verifier-limitation";

    @Override
    public Optional<String> resolve(QueryStats controlQueryStats, QueryException queryException, Optional<QueryBundle> test) {
        return FailureResolverUtil.mapMatchingPrestoException(queryException, QueryStage.CONTROL_CHECKSUM, (ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, e -> Optional.of("Checksum query too large"));
    }

    public static class Factory
    implements FailureResolverFactory {
        @Override
        public FailureResolver create(FailureResolverFactoryContext context) {
            return new VerifierLimitationFailureResolver();
        }
    }
}

