/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.verifier.framework.PrestoQueryException;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryStage;
import java.util.Optional;
import java.util.function.Function;

public class FailureResolverUtil {
    private FailureResolverUtil() {
    }

    public static <T> Optional<T> mapMatchingPrestoException(QueryException queryException, QueryStage queryStage, ErrorCodeSupplier errorCode, Function<PrestoQueryException, Optional<T>> mapper) {
        if (queryException.getQueryStage() != queryStage || !(queryException instanceof PrestoQueryException)) {
            return Optional.empty();
        }
        PrestoQueryException prestoException = (PrestoQueryException)queryException;
        if (!prestoException.getErrorCode().equals(Optional.of(errorCode))) {
            return Optional.empty();
        }
        return mapper.apply(prestoException);
    }
}

