/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.resolver.FailureResolver;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class FailureResolverManager {
    private final Set<FailureResolver> failureResolvers;

    public FailureResolverManager(Set<FailureResolver> failureResolvers) {
        this.failureResolvers = Objects.requireNonNull(failureResolvers, "failureResolvers is null");
    }

    public Optional<String> resolve(QueryStats controlQueryStats, Throwable throwable, Optional<QueryBundle> test) {
        if (!(throwable instanceof QueryException)) {
            return Optional.of("Verifier Error");
        }
        for (FailureResolver failureResolver : this.failureResolvers) {
            Optional<String> resolveMessage = failureResolver.resolve(controlQueryStats, (QueryException)throwable, test);
            if (!resolveMessage.isPresent()) continue;
            return resolveMessage;
        }
        return Optional.empty();
    }
}

