/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.presto.connector.thrift.ThriftErrorCode;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.verifier.framework.ClusterConnectionException;
import com.facebook.presto.verifier.framework.PrestoQueryException;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.EOFException;
import java.io.UncheckedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.regex.Pattern;

public class PrestoExceptionClassifier
implements SqlExceptionClassifier {
    public static final Set<ErrorCodeSupplier> DEFAULT_ERRORS = ImmutableSet.builder().addAll(Arrays.asList(StandardErrorCode.values())).addAll(Arrays.asList(HiveErrorCode.values())).addAll(Arrays.asList(JdbcErrorCode.values())).addAll(Arrays.asList(ThriftErrorCode.values())).build();
    public static final Set<ErrorCodeSupplier> DEFAULT_RETRYABLE_ERRORS = ImmutableSet.of((Object)StandardErrorCode.NO_NODES_AVAILABLE, (Object)StandardErrorCode.REMOTE_TASK_ERROR, (Object)StandardErrorCode.SERVER_SHUTTING_DOWN, (Object)StandardErrorCode.SERVER_STARTING_UP, (Object)StandardErrorCode.TOO_MANY_REQUESTS_FAILED, (Object)StandardErrorCode.PAGE_TRANSPORT_ERROR, (Object[])new ErrorCodeSupplier[]{StandardErrorCode.PAGE_TRANSPORT_TIMEOUT, StandardErrorCode.REMOTE_HOST_GONE, StandardErrorCode.ABANDONED_TASK, HiveErrorCode.HIVE_CURSOR_ERROR, HiveErrorCode.HIVE_FILE_NOT_FOUND, HiveErrorCode.HIVE_TOO_MANY_OPEN_PARTITIONS, HiveErrorCode.HIVE_WRITER_OPEN_ERROR, HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, HiveErrorCode.HIVE_WRITER_DATA_ERROR, HiveErrorCode.HIVE_FILESYSTEM_ERROR, HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, HiveErrorCode.HIVE_METASTORE_ERROR, JdbcErrorCode.JDBC_ERROR, ThriftErrorCode.THRIFT_SERVICE_CONNECTION_ERROR});
    private static final Set<ErrorCodeSupplier> DEFAULT_REQUEUABLE_ERRORS = ImmutableSet.of((Object)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, (Object)HiveErrorCode.HIVE_TABLE_DROPPED_DURING_QUERY);
    private static final Pattern TABLE_ALREADY_EXISTS_PATTERN = Pattern.compile("table.*already exists", 2);
    private final Map<Integer, ErrorCodeSupplier> errorByCode;
    private final Set<ErrorCodeSupplier> retryableErrors;

    private PrestoExceptionClassifier(Set<ErrorCodeSupplier> recognizedErrors, Set<ErrorCodeSupplier> retryableErrors) {
        this.errorByCode = (Map)recognizedErrors.stream().collect(ImmutableMap.toImmutableMap(errorCode -> errorCode.toErrorCode().getCode(), (Function)Functions.identity()));
        this.retryableErrors = ImmutableSet.copyOf(retryableErrors);
    }

    public static PrestoExceptionClassifier createDefault() {
        return PrestoExceptionClassifier.create(DEFAULT_ERRORS, DEFAULT_RETRYABLE_ERRORS);
    }

    public static PrestoExceptionClassifier create(Set<ErrorCodeSupplier> recognizedErrors, Set<ErrorCodeSupplier> retryableErrors) {
        Sets.SetView unrecognized = Sets.difference(retryableErrors, recognizedErrors);
        Preconditions.checkArgument((boolean)unrecognized.isEmpty(), (String)"Retryable errors not recognized: %s", (Object)unrecognized);
        return new PrestoExceptionClassifier(recognizedErrors, retryableErrors);
    }

    @Override
    public QueryException createException(QueryStage queryStage, Optional<QueryStats> queryStats, SQLException cause) {
        Optional<Throwable> clusterConnectionExceptionCause = PrestoExceptionClassifier.getClusterConnectionExceptionCause(cause);
        if (clusterConnectionExceptionCause.isPresent()) {
            return new ClusterConnectionException(clusterConnectionExceptionCause.get(), queryStage);
        }
        Optional<ErrorCodeSupplier> errorCode = Optional.ofNullable(this.errorByCode.get(cause.getErrorCode()));
        return new PrestoQueryException(cause, errorCode.isPresent() && this.retryableErrors.contains(errorCode.get()), queryStage, errorCode, queryStats);
    }

    public static boolean shouldResubmit(Throwable throwable) {
        if (!(throwable instanceof PrestoQueryException)) {
            return false;
        }
        PrestoQueryException queryException = (PrestoQueryException)throwable;
        Optional<ErrorCodeSupplier> errorCode = queryException.getErrorCode();
        return errorCode.isPresent() && DEFAULT_REQUEUABLE_ERRORS.contains(errorCode.get()) || PrestoExceptionClassifier.isTargetTableAlreadyExistsException(queryException);
    }

    public static boolean isClusterConnectionException(Throwable t) {
        return PrestoExceptionClassifier.getClusterConnectionExceptionCause(t).isPresent();
    }

    private static Optional<Throwable> getClusterConnectionExceptionCause(Throwable t) {
        while (t != null) {
            if (t instanceof SocketTimeoutException || t instanceof SocketException || t instanceof EOFException || t instanceof UncheckedIOException || t instanceof TimeoutException || t.getClass().equals(RuntimeException.class) && t.getMessage() != null && t.getMessage().contains("Error fetching next at")) {
                return Optional.of(t);
            }
            t = t.getCause();
        }
        return Optional.empty();
    }

    private static boolean isTargetTableAlreadyExistsException(PrestoQueryException queryException) {
        return queryException.getErrorCode().equals(Optional.of(StandardErrorCode.SYNTAX_ERROR)) && queryException.getQueryStage().isSetup() && TABLE_ALREADY_EXISTS_PATTERN.matcher(queryException.getMessage()).find();
    }
}

