/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.verifier.annotation.ForTest;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.framework.DataVerification;
import com.facebook.presto.verifier.framework.DeterminismAnalyzer;
import com.facebook.presto.verifier.framework.DeterminismAnalyzerConfig;
import com.facebook.presto.verifier.framework.QueryType;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.Verification;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.NodeResourceClient;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.prestoaction.PrestoActionFactory;
import com.facebook.presto.verifier.resolver.FailureResolverFactoryContext;
import com.facebook.presto.verifier.resolver.FailureResolverManager;
import com.facebook.presto.verifier.resolver.FailureResolverManagerFactory;
import com.facebook.presto.verifier.rewrite.QueryRewriter;
import com.facebook.presto.verifier.rewrite.QueryRewriterFactory;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class VerificationFactory {
    private final SqlParser sqlParser;
    private final PrestoActionFactory prestoActionFactory;
    private final QueryRewriterFactory queryRewriterFactory;
    private final FailureResolverManagerFactory failureResolverManagerFactory;
    private final NodeResourceClient testResourceClient;
    private final ChecksumValidator checksumValidator;
    private final VerifierConfig verifierConfig;
    private final TypeManager typeManager;
    private final DeterminismAnalyzerConfig determinismAnalyzerConfig;

    @Inject
    public VerificationFactory(SqlParser sqlParser, PrestoActionFactory prestoActionFactory, QueryRewriterFactory queryRewriterFactory, FailureResolverManagerFactory failureResolverManagerFactory, @ForTest NodeResourceClient testResourceClient, ChecksumValidator checksumValidator, VerifierConfig verifierConfig, TypeManager typeManager, DeterminismAnalyzerConfig determinismAnalyzerConfig) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.prestoActionFactory = Objects.requireNonNull(prestoActionFactory, "prestoActionFactory is null");
        this.queryRewriterFactory = Objects.requireNonNull(queryRewriterFactory, "queryRewriterFactory is null");
        this.failureResolverManagerFactory = Objects.requireNonNull(failureResolverManagerFactory, "failureResolverManagerFactory is null");
        this.testResourceClient = Objects.requireNonNull(testResourceClient, "testResourceClient is null");
        this.checksumValidator = Objects.requireNonNull(checksumValidator, "checksumValidator is null");
        this.verifierConfig = Objects.requireNonNull(verifierConfig, "config is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.determinismAnalyzerConfig = Objects.requireNonNull(determinismAnalyzerConfig, "determinismAnalyzerConfig is null");
    }

    public Verification get(SourceQuery sourceQuery, Optional<VerificationContext> existingContext) {
        QueryType queryType = QueryType.of(this.sqlParser.createStatement(sourceQuery.getControlQuery(), VerifierUtil.PARSING_OPTIONS));
        switch (queryType.getCategory()) {
            case DATA_PRODUCING: {
                VerificationContext verificationContext = existingContext.map(VerificationContext::createForResubmission).orElseGet(VerificationContext::create);
                PrestoAction prestoAction = this.prestoActionFactory.create(sourceQuery, verificationContext);
                QueryRewriter queryRewriter = this.queryRewriterFactory.create(prestoAction);
                DeterminismAnalyzer determinismAnalyzer = new DeterminismAnalyzer(sourceQuery, prestoAction, queryRewriter, this.checksumValidator, this.typeManager, verificationContext, this.determinismAnalyzerConfig);
                FailureResolverManager failureResolverManager = this.failureResolverManagerFactory.create(new FailureResolverFactoryContext(this.sqlParser, prestoAction, this.testResourceClient));
                return new DataVerification(prestoAction, sourceQuery, queryRewriter, determinismAnalyzer, failureResolverManager, verificationContext, this.verifierConfig, this.typeManager, this.checksumValidator);
            }
        }
        throw new IllegalStateException(String.format("Unsupported query type: %s", new Object[]{queryType}));
    }
}

