/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.verifier.event.QueryFailure;
import com.facebook.presto.verifier.framework.QueryException;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VerificationContext {
    private final int resubmissionCount;
    private final Set<QueryException> queryExceptions;

    private VerificationContext(int resubmissionCount, Set<QueryException> queryExceptions) {
        this.resubmissionCount = resubmissionCount;
        this.queryExceptions = new HashSet<QueryException>(queryExceptions);
    }

    public static VerificationContext create() {
        return new VerificationContext(0, new HashSet<QueryException>());
    }

    public static VerificationContext createForResubmission(VerificationContext existing) {
        return new VerificationContext(existing.resubmissionCount + 1, existing.queryExceptions);
    }

    public int getResubmissionCount() {
        return this.resubmissionCount;
    }

    public void addException(QueryException exception) {
        this.queryExceptions.add(exception);
    }

    public List<QueryFailure> getQueryFailures() {
        return (List)this.queryExceptions.stream().map(QueryException::toQueryFailure).collect(ImmutableList.toImmutableList());
    }
}

