/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.verifier.event.DeterminismAnalysisDetails;
import com.facebook.presto.verifier.framework.LimitQueryDeterminismAnalysis;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class LimitQueryDeterminismAnalyzer {
    private final PrestoAction prestoAction;
    private final boolean enabled;
    private final Statement statement;
    private final long rowCount;
    private final DeterminismAnalysisDetails.Builder determinismAnalysisDetails;

    public LimitQueryDeterminismAnalyzer(PrestoAction prestoAction, boolean enabled, Statement statement, long rowCount, DeterminismAnalysisDetails.Builder determinismAnalysisDetails) {
        this.prestoAction = Objects.requireNonNull(prestoAction, "prestoAction is null");
        this.enabled = enabled;
        this.statement = Objects.requireNonNull(statement, "statement is null");
        Preconditions.checkArgument((rowCount >= 0L ? 1 : 0) != 0, (String)"rowCount is negative: %s", (long)rowCount);
        this.rowCount = rowCount;
        this.determinismAnalysisDetails = Objects.requireNonNull(determinismAnalysisDetails, "determinismAnalysisDetails is null");
    }

    public LimitQueryDeterminismAnalysis analyze() {
        LimitQueryDeterminismAnalysis analysis = this.analyzeInternal();
        this.determinismAnalysisDetails.setLimitQueryAnalysis(analysis);
        return analysis;
    }

    private LimitQueryDeterminismAnalysis analyzeInternal() {
        Query query;
        if (!this.enabled) {
            return LimitQueryDeterminismAnalysis.NOT_RUN;
        }
        if (this.statement instanceof Insert) {
            query = ((Insert)this.statement).getQuery();
        } else if (this.statement instanceof CreateTableAsSelect) {
            query = ((CreateTableAsSelect)this.statement).getQuery();
        } else {
            return LimitQueryDeterminismAnalysis.NOT_RUN;
        }
        if (query.getQueryBody() instanceof TableSubquery) {
            Optional with = query.getWith();
            while (query.getQueryBody() instanceof TableSubquery) {
                if (query.getOrderBy().isPresent() || query.getLimit().isPresent()) {
                    return LimitQueryDeterminismAnalysis.NOT_RUN;
                }
                if (!(query = ((TableSubquery)query.getQueryBody()).getQuery()).getWith().isPresent()) continue;
                return LimitQueryDeterminismAnalysis.NOT_RUN;
            }
            query = new Query(with, query.getQueryBody(), query.getOrderBy(), query.getLimit());
        }
        if (query.getQueryBody() instanceof QuerySpecification) {
            return this.analyzeQuerySpecification(query.getWith(), (QuerySpecification)query.getQueryBody());
        }
        return this.analyzeQuery(query);
    }

    private LimitQueryDeterminismAnalysis analyzeQuery(Query query) {
        if (query.getOrderBy().isPresent() || !query.getLimit().isPresent()) {
            return LimitQueryDeterminismAnalysis.NOT_RUN;
        }
        if (LimitQueryDeterminismAnalyzer.isLimitAll((String)query.getLimit().get())) {
            return LimitQueryDeterminismAnalysis.NOT_RUN;
        }
        long limit = Long.parseLong((String)query.getLimit().get());
        Optional<String> newLimit = Optional.of(Long.toString(limit + 1L));
        Query newLimitQuery = new Query(query.getWith(), query.getQueryBody(), Optional.empty(), newLimit);
        return this.analyzeLimitNoOrderBy(newLimitQuery, limit);
    }

    private List<ColumnNameOrIndex> populateSelectItems(List<SelectItem> selectItems, OrderBy orderBy) {
        Set aliases = (Set)selectItems.stream().filter(SingleColumn.class::isInstance).map(SingleColumn.class::cast).map(SingleColumn::getAlias).filter(Optional::isPresent).map(Optional::get).map(Identifier::getValue).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder orderByKeys = ImmutableList.builder();
        for (int i = 0; i < orderBy.getSortItems().size(); ++i) {
            Expression sortKey = ((SortItem)orderBy.getSortItems().get(i)).getSortKey();
            if (sortKey instanceof LongLiteral) {
                orderByKeys.add((Object)ColumnNameOrIndex.forIndex(Math.toIntExact(((LongLiteral)sortKey).getValue()) - 1));
                continue;
            }
            if (sortKey instanceof Identifier && aliases.contains(((Identifier)sortKey).getValue())) {
                orderByKeys.add((Object)ColumnNameOrIndex.forName(((Identifier)sortKey).getValue()));
                continue;
            }
            String columnName = "$$sort_key$$" + i;
            selectItems.add((SelectItem)new SingleColumn(sortKey, VerifierUtil.delimitedIdentifier(columnName)));
            orderByKeys.add((Object)ColumnNameOrIndex.forName(columnName));
        }
        return orderByKeys.build();
    }

    private LimitQueryDeterminismAnalysis analyzeQuerySpecification(Optional<With> with, QuerySpecification querySpecification) {
        if (!querySpecification.getLimit().isPresent()) {
            return LimitQueryDeterminismAnalysis.NOT_RUN;
        }
        if (LimitQueryDeterminismAnalyzer.isLimitAll((String)querySpecification.getLimit().get())) {
            return LimitQueryDeterminismAnalysis.NOT_RUN;
        }
        long limit = Long.parseLong((String)querySpecification.getLimit().get());
        Optional<String> newLimit = Optional.of(Long.toString(limit + 1L));
        Optional orderBy = querySpecification.getOrderBy();
        if (orderBy.isPresent()) {
            ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>(querySpecification.getSelect().getSelectItems());
            List<ColumnNameOrIndex> orderByKeys = this.populateSelectItems(selectItems, (OrderBy)orderBy.get());
            return this.analyzeLimitOrderBy(new Query(with, (QueryBody)new QuerySpecification(new Select(false, selectItems), querySpecification.getFrom(), querySpecification.getWhere(), querySpecification.getGroupBy(), querySpecification.getHaving(), orderBy, newLimit), Optional.empty(), Optional.empty()), orderByKeys, limit);
        }
        Query newLimitQuery = new Query(with, (QueryBody)new QuerySpecification(querySpecification.getSelect(), querySpecification.getFrom(), querySpecification.getWhere(), querySpecification.getGroupBy(), querySpecification.getHaving(), Optional.empty(), newLimit), Optional.empty(), Optional.empty());
        return this.analyzeLimitNoOrderBy(newLimitQuery, limit);
    }

    private LimitQueryDeterminismAnalysis analyzeLimitNoOrderBy(Query newLimitQuery, long limit) {
        Query rowCountQuery = QueryUtil.simpleQuery((Select)new Select(false, (List)ImmutableList.of((Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of((Object)new LongLiteral("1")))))), (Relation)new TableSubquery(newLimitQuery));
        QueryResult result = VerifierUtil.callAndConsume(() -> this.prestoAction.execute((Statement)rowCountQuery, QueryStage.DETERMINISM_ANALYSIS, resultSet -> Optional.of(resultSet.getLong(1))), stats -> this.determinismAnalysisDetails.setLimitQueryAnalysisQueryId(stats.getQueryId()));
        long rowCountHigherLimit = (Long)Iterables.getOnlyElement(result.getResults());
        if (rowCountHigherLimit == this.rowCount) {
            return LimitQueryDeterminismAnalysis.DETERMINISTIC;
        }
        if (this.rowCount >= limit && rowCountHigherLimit > this.rowCount) {
            return LimitQueryDeterminismAnalysis.NON_DETERMINISTIC;
        }
        return LimitQueryDeterminismAnalysis.FAILED_DATA_CHANGED;
    }

    private LimitQueryDeterminismAnalysis analyzeLimitOrderBy(Query tieInspectorQuery, List<ColumnNameOrIndex> orderByKeys, long limit) {
        QueryResult result = VerifierUtil.callAndConsume(() -> this.prestoAction.execute((Statement)tieInspectorQuery, QueryStage.DETERMINISM_ANALYSIS, new TieInspector(limit)), stats -> this.determinismAnalysisDetails.setLimitQueryAnalysisQueryId(stats.getQueryId()));
        if (result.getResults().isEmpty()) {
            return LimitQueryDeterminismAnalysis.FAILED_DATA_CHANGED;
        }
        if (result.getResults().size() == 1) {
            return LimitQueryDeterminismAnalysis.DETERMINISTIC;
        }
        List row1 = (List)result.getResults().get(0);
        List row2 = (List)result.getResults().get(1);
        Preconditions.checkState((row1.size() == row2.size() ? 1 : 0) != 0, (String)"Rows have different sizes: %s %s", (int)row1.size(), (int)row2.size());
        Map<String, Integer> columnIndices = VerifierUtil.getColumnIndices(result.getMetadata());
        for (ColumnNameOrIndex orderByKey : orderByKeys) {
            int columnIndex = orderByKey.getIndex().isPresent() ? orderByKey.getIndex().get().intValue() : columnIndices.get(orderByKey.getName().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid orderByKey: %s", orderByKey)))).intValue();
            if (Objects.equals(row1.get(columnIndex), row2.get(columnIndex))) continue;
            return LimitQueryDeterminismAnalysis.DETERMINISTIC;
        }
        return LimitQueryDeterminismAnalysis.NON_DETERMINISTIC;
    }

    private static boolean isLimitAll(String limitClause) {
        return limitClause.toLowerCase(Locale.ENGLISH).equals("all");
    }

    private static class TieInspector
    implements PrestoAction.ResultSetConverter<List<Object>> {
        private final long limit;
        private long row;

        public TieInspector(long limit) {
            this.limit = limit;
        }

        @Override
        public Optional<List<Object>> apply(ResultSet resultSet) throws SQLException {
            ++this.row;
            if (this.row != this.limit && this.row != this.limit + 1L) {
                return Optional.empty();
            }
            return PrestoAction.ResultSetConverter.DEFAULT.apply(resultSet);
        }
    }

    private static class ColumnNameOrIndex {
        private final Optional<String> name;
        private final Optional<Integer> index;

        private ColumnNameOrIndex(Optional<String> name, Optional<Integer> index) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.index = Objects.requireNonNull(index, "index is null");
            Preconditions.checkState((boolean)(this.name.isPresent() ^ this.index.isPresent()), (String)"Exactly one of name and index must be present: %s %s", this.name, this.index);
        }

        public static ColumnNameOrIndex forName(String name) {
            return new ColumnNameOrIndex(Optional.of(name), Optional.empty());
        }

        public static ColumnNameOrIndex forIndex(int index) {
            return new ColumnNameOrIndex(Optional.empty(), Optional.of(index));
        }

        public Optional<String> getName() {
            return this.name;
        }

        public Optional<Integer> getIndex() {
            return this.index;
        }
    }
}

