/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.event.DeterminismAnalysisDetails;
import com.facebook.presto.verifier.event.DeterminismAnalysisRun;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.DataVerificationUtil;
import com.facebook.presto.verifier.framework.DeterminismAnalysis;
import com.facebook.presto.verifier.framework.DeterminismAnalyzerConfig;
import com.facebook.presto.verifier.framework.LimitQueryDeterminismAnalysis;
import com.facebook.presto.verifier.framework.LimitQueryDeterminismAnalyzer;
import com.facebook.presto.verifier.framework.MatchResult;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.rewrite.QueryRewriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class DeterminismAnalyzer {
    private final SourceQuery sourceQuery;
    private final PrestoAction prestoAction;
    private final QueryRewriter queryRewriter;
    private final ChecksumValidator checksumValidator;
    private final TypeManager typeManager;
    private final VerificationContext verificationContext;
    private boolean runTeardown;
    private int maxAnalysisRuns;
    private Set<String> nonDeterministicCatalogs;
    private boolean handleLimitQuery;

    public DeterminismAnalyzer(SourceQuery sourceQuery, PrestoAction prestoAction, QueryRewriter queryRewriter, ChecksumValidator checksumValidator, TypeManager typeManager, VerificationContext verificationContext, DeterminismAnalyzerConfig config) {
        this.sourceQuery = Objects.requireNonNull(sourceQuery, "sourceQuery is null");
        this.prestoAction = Objects.requireNonNull(prestoAction, "prestoAction is null");
        this.queryRewriter = Objects.requireNonNull(queryRewriter, "queryRewriter is null");
        this.checksumValidator = Objects.requireNonNull(checksumValidator, "checksumValidator is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.verificationContext = Objects.requireNonNull(verificationContext, "verificationContext is null");
        this.runTeardown = config.isRunTeardown();
        this.maxAnalysisRuns = config.getMaxAnalysisRuns();
        this.nonDeterministicCatalogs = ImmutableSet.copyOf(config.getNonDeterministicCatalogs());
        this.handleLimitQuery = config.isHandleLimitQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeterminismAnalysis analyze(QueryBundle control, ChecksumResult controlChecksum, DeterminismAnalysisDetails.Builder determinismAnalysisDetails) {
        if (this.isNonDeterministicCatalogReferenced(control.getQuery())) {
            return DeterminismAnalysis.NON_DETERMINISTIC_CATALOG;
        }
        List<Column> columns = DataVerificationUtil.getColumns(this.prestoAction, this.typeManager, control.getTableName());
        ArrayList<QueryBundle> queryBundles = new ArrayList<QueryBundle>();
        try {
            DeterminismAnalysis determinismAnalysis;
            for (int i = 0; i < this.maxAnalysisRuns; ++i) {
                QueryBundle queryBundle = this.queryRewriter.rewriteQuery(this.sourceQuery.getControlQuery(), ClusterType.CONTROL);
                queryBundles.add(queryBundle);
                DeterminismAnalysisRun.Builder run = determinismAnalysisDetails.addRun().setTableName(queryBundle.getTableName().toString());
                VerifierUtil.runAndConsume(() -> DataVerificationUtil.setupAndRun(this.prestoAction, queryBundle, true), stats -> run.setQueryId(stats.getQueryId()));
                Query checksumQuery = this.checksumValidator.generateChecksumQuery(queryBundle.getTableName(), columns);
                ChecksumResult testChecksum = (ChecksumResult)Iterables.getOnlyElement(VerifierUtil.callAndConsume(() -> this.prestoAction.execute((Statement)checksumQuery, QueryStage.DETERMINISM_ANALYSIS_CHECKSUM, ChecksumResult::fromResultSet), stats -> run.setChecksumQueryId(stats.getQueryId())).getResults());
                DeterminismAnalysis analysis = this.matchResultToDeterminism(DataVerificationUtil.match(this.checksumValidator, columns, columns, controlChecksum, testChecksum));
                if (analysis == DeterminismAnalysis.DETERMINISTIC) continue;
                DeterminismAnalysis determinismAnalysis2 = analysis;
                return determinismAnalysis2;
            }
            LimitQueryDeterminismAnalysis limitQueryAnalysis = new LimitQueryDeterminismAnalyzer(this.prestoAction, this.handleLimitQuery, control.getQuery(), controlChecksum.getRowCount(), determinismAnalysisDetails).analyze();
            switch (limitQueryAnalysis) {
                case NON_DETERMINISTIC: {
                    determinismAnalysis = DeterminismAnalysis.NON_DETERMINISTIC_LIMIT_CLAUSE;
                    return determinismAnalysis;
                }
                case NOT_RUN: 
                case DETERMINISTIC: {
                    determinismAnalysis = DeterminismAnalysis.DETERMINISTIC;
                    return determinismAnalysis;
                }
                case FAILED_DATA_CHANGED: {
                    determinismAnalysis = DeterminismAnalysis.ANALYSIS_FAILED_DATA_CHANGED;
                    return determinismAnalysis;
                }
            }
            try {
                throw new IllegalArgumentException(String.format("Invalid limitQueryAnalysis: %s", new Object[]{limitQueryAnalysis}));
            }
            catch (QueryException qe) {
                determinismAnalysis = DeterminismAnalysis.ANALYSIS_FAILED_QUERY_FAILURE;
                return determinismAnalysis;
            }
            catch (Throwable t) {
                determinismAnalysis = DeterminismAnalysis.ANALYSIS_FAILED;
                return determinismAnalysis;
            }
        }
        finally {
            if (this.runTeardown) {
                queryBundles.forEach(bundle -> DataVerificationUtil.teardownSafely(this.prestoAction, Optional.of(bundle)));
            }
        }
    }

    private DeterminismAnalysis matchResultToDeterminism(MatchResult matchResult) {
        switch (matchResult.getMatchType()) {
            case MATCH: {
                return DeterminismAnalysis.DETERMINISTIC;
            }
            case SCHEMA_MISMATCH: {
                return DeterminismAnalysis.ANALYSIS_FAILED_INCONSISTENT_SCHEMA;
            }
            case ROW_COUNT_MISMATCH: {
                return DeterminismAnalysis.NON_DETERMINISTIC_ROW_COUNT;
            }
            case COLUMN_MISMATCH: {
                return DeterminismAnalysis.NON_DETERMINISTIC_COLUMNS;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid MatchResult: %s", matchResult));
    }

    @VisibleForTesting
    boolean isNonDeterministicCatalogReferenced(Statement statement) {
        if (this.nonDeterministicCatalogs.isEmpty()) {
            return false;
        }
        AtomicBoolean nonDeterministicCatalogReferenced = new AtomicBoolean();
        new NonDeterministicCatalogVisitor().process((Node)statement, nonDeterministicCatalogReferenced);
        return nonDeterministicCatalogReferenced.get();
    }

    private class NonDeterministicCatalogVisitor
    extends AstVisitor<Void, AtomicBoolean> {
        private NonDeterministicCatalogVisitor() {
        }

        protected Void visitNode(Node node, AtomicBoolean context) {
            node.getChildren().forEach(child -> {
                Void cfr_ignored_0 = (Void)this.process((Node)child, context);
            });
            return null;
        }

        protected Void visitTable(Table node, AtomicBoolean nonDeterministicCatalogReferenced) {
            if (node.getName().getParts().size() == 3 && DeterminismAnalyzer.this.nonDeterministicCatalogs.contains(node.getName().getParts().get(0))) {
                nonDeterministicCatalogReferenced.set(true);
            }
            return null;
        }
    }
}

