/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.MatchResult;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;

public class DataVerificationUtil {
    private static final Logger log = Logger.get(DataVerificationUtil.class);

    private DataVerificationUtil() {
    }

    public static QueryStats setupAndRun(PrestoAction prestoAction, QueryBundle bundle, boolean determinismAnalysis) {
        Preconditions.checkState((!determinismAnalysis || bundle.getCluster() == ClusterType.CONTROL ? 1 : 0) != 0, (Object)"Determinism analysis can only be run on control cluster");
        QueryStage setupStage = determinismAnalysis ? QueryStage.DETERMINISM_ANALYSIS : QueryStage.forSetup(bundle.getCluster());
        QueryStage mainStage = determinismAnalysis ? QueryStage.DETERMINISM_ANALYSIS : QueryStage.forMain(bundle.getCluster());
        for (Statement setupQuery : bundle.getSetupQueries()) {
            prestoAction.execute(setupQuery, setupStage);
        }
        return prestoAction.execute(bundle.getQuery(), mainStage);
    }

    public static void teardownSafely(PrestoAction prestoAction, Optional<QueryBundle> bundle) {
        if (!bundle.isPresent()) {
            return;
        }
        for (Statement teardownQuery : bundle.get().getTeardownQueries()) {
            try {
                prestoAction.execute(teardownQuery, QueryStage.forTeardown(bundle.get().getCluster()));
            }
            catch (Throwable t) {
                log.warn("Failed to teardown %s: %s", new Object[]{bundle.get().getCluster().name().toLowerCase(Locale.ENGLISH), SqlFormatter.formatSql((Node)teardownQuery, Optional.empty())});
            }
        }
    }

    public static List<Column> getColumns(PrestoAction prestoAction, TypeManager typeManager, QualifiedName tableName) {
        return prestoAction.execute((Statement)new ShowColumns(tableName), QueryStage.DESCRIBE, resultSet -> Optional.of(Column.fromResultSet(typeManager, resultSet))).getResults();
    }

    public static MatchResult match(ChecksumValidator checksumValidator, List<Column> controlColumns, List<Column> testColumns, ChecksumResult controlChecksum, ChecksumResult testChecksum) {
        MatchResult.MatchType matchType;
        Object mismatchedColumns;
        if (!controlColumns.equals(testColumns)) {
            return new MatchResult(MatchResult.MatchType.SCHEMA_MISMATCH, Optional.empty(), OptionalLong.empty(), OptionalLong.empty(), (Map<Column, ColumnMatchResult>)ImmutableMap.of());
        }
        OptionalLong controlRowCount = OptionalLong.of(controlChecksum.getRowCount());
        OptionalLong testRowCount = OptionalLong.of(testChecksum.getRowCount());
        if (controlChecksum.getRowCount() != testChecksum.getRowCount()) {
            mismatchedColumns = ImmutableMap.of();
            matchType = MatchResult.MatchType.ROW_COUNT_MISMATCH;
        } else {
            mismatchedColumns = checksumValidator.getMismatchedColumns(controlColumns, controlChecksum, testChecksum);
            matchType = mismatchedColumns.isEmpty() ? MatchResult.MatchType.MATCH : MatchResult.MatchType.COLUMN_MISMATCH;
        }
        return new MatchResult(matchType, Optional.of(controlChecksum), controlRowCount, testRowCount, (Map<Column, ColumnMatchResult>)mismatchedColumns);
    }
}

