/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.framework.AbstractVerification;
import com.facebook.presto.verifier.framework.ChecksumQueryContext;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.DataVerificationUtil;
import com.facebook.presto.verifier.framework.DeterminismAnalyzer;
import com.facebook.presto.verifier.framework.MatchResult;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.resolver.FailureResolverManager;
import com.facebook.presto.verifier.rewrite.QueryRewriter;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;

public class DataVerification
extends AbstractVerification {
    private final TypeManager typeManager;
    private final ChecksumValidator checksumValidator;

    public DataVerification(PrestoAction prestoAction, SourceQuery sourceQuery, QueryRewriter queryRewriter, DeterminismAnalyzer determinismAnalyzer, FailureResolverManager failureResolverManager, VerificationContext verificationContext, VerifierConfig verifierConfig, TypeManager typeManager, ChecksumValidator checksumValidator) {
        super(prestoAction, sourceQuery, queryRewriter, determinismAnalyzer, failureResolverManager, verificationContext, verifierConfig);
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.checksumValidator = Objects.requireNonNull(checksumValidator, "checksumValidator is null");
    }

    @Override
    public MatchResult verify(QueryBundle control, QueryBundle test, ChecksumQueryContext controlContext, ChecksumQueryContext testContext) {
        List<Column> controlColumns = DataVerificationUtil.getColumns(this.getPrestoAction(), this.typeManager, control.getTableName());
        List<Column> testColumns = DataVerificationUtil.getColumns(this.getPrestoAction(), this.typeManager, test.getTableName());
        Query controlChecksumQuery = this.checksumValidator.generateChecksumQuery(control.getTableName(), controlColumns);
        Query testChecksumQuery = this.checksumValidator.generateChecksumQuery(test.getTableName(), testColumns);
        controlContext.setChecksumQuery(DataVerification.formatSql((Statement)controlChecksumQuery));
        testContext.setChecksumQuery(DataVerification.formatSql((Statement)testChecksumQuery));
        QueryResult controlChecksum = VerifierUtil.callAndConsume(() -> this.getPrestoAction().execute((Statement)controlChecksumQuery, QueryStage.CONTROL_CHECKSUM, ChecksumResult::fromResultSet), stats -> controlContext.setChecksumQueryId(stats.getQueryId()));
        QueryResult testChecksum = VerifierUtil.callAndConsume(() -> this.getPrestoAction().execute((Statement)testChecksumQuery, QueryStage.TEST_CHECKSUM, ChecksumResult::fromResultSet), stats -> testContext.setChecksumQueryId(stats.getQueryId()));
        return DataVerificationUtil.match(this.checksumValidator, controlColumns, testColumns, (ChecksumResult)Iterables.getOnlyElement(controlChecksum.getResults()), (ChecksumResult)Iterables.getOnlyElement(testChecksum.getResults()));
    }
}

