/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.event.DeterminismAnalysisDetails;
import com.facebook.presto.verifier.event.QueryInfo;
import com.facebook.presto.verifier.event.VerifierQueryEvent;
import com.facebook.presto.verifier.framework.ChecksumQueryContext;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.DataVerificationUtil;
import com.facebook.presto.verifier.framework.DeterminismAnalysis;
import com.facebook.presto.verifier.framework.DeterminismAnalyzer;
import com.facebook.presto.verifier.framework.MatchResult;
import com.facebook.presto.verifier.framework.PrestoQueryException;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.QueryState;
import com.facebook.presto.verifier.framework.SkippedReason;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.Verification;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerificationResult;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.prestoaction.PrestoExceptionClassifier;
import com.facebook.presto.verifier.resolver.FailureResolverManager;
import com.facebook.presto.verifier.rewrite.QueryRewriter;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public abstract class AbstractVerification
implements Verification {
    private static final String INTERNAL_ERROR = "VERIFIER_INTERNAL_ERROR";
    private final PrestoAction prestoAction;
    private final SourceQuery sourceQuery;
    private final QueryRewriter queryRewriter;
    private final DeterminismAnalyzer determinismAnalyzer;
    private final FailureResolverManager failureResolverManager;
    private final VerificationContext verificationContext;
    private final String testId;
    private final boolean smartTeardown;
    private final int verificationResubmissionLimit;

    public AbstractVerification(PrestoAction prestoAction, SourceQuery sourceQuery, QueryRewriter queryRewriter, DeterminismAnalyzer determinismAnalyzer, FailureResolverManager failureResolverManager, VerificationContext verificationContext, VerifierConfig verifierConfig) {
        this.prestoAction = Objects.requireNonNull(prestoAction, "prestoAction is null");
        this.sourceQuery = Objects.requireNonNull(sourceQuery, "sourceQuery is null");
        this.queryRewriter = Objects.requireNonNull(queryRewriter, "queryRewriter is null");
        this.determinismAnalyzer = Objects.requireNonNull(determinismAnalyzer, "determinismAnalyzer is null");
        this.failureResolverManager = Objects.requireNonNull(failureResolverManager, "failureResolverManager is null");
        this.verificationContext = Objects.requireNonNull(verificationContext, "verificationContext is null");
        this.testId = Objects.requireNonNull(verifierConfig.getTestId(), "testId is null");
        this.smartTeardown = verifierConfig.isSmartTeardown();
        this.verificationResubmissionLimit = verifierConfig.getVerificationResubmissionLimit();
    }

    protected abstract MatchResult verify(QueryBundle var1, QueryBundle var2, ChecksumQueryContext var3, ChecksumQueryContext var4);

    protected PrestoAction getPrestoAction() {
        return this.prestoAction;
    }

    @Override
    public SourceQuery getSourceQuery() {
        return this.sourceQuery;
    }

    @Override
    public VerificationContext getVerificationContext() {
        return this.verificationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerificationResult run() {
        Optional<QueryBundle> control = Optional.empty();
        Optional<QueryBundle> test = Optional.empty();
        QueryContext controlQueryContext = new QueryContext();
        QueryContext testQueryContext = new QueryContext();
        ChecksumQueryContext controlChecksumQueryContext = new ChecksumQueryContext();
        ChecksumQueryContext testChecksumQueryContext = new ChecksumQueryContext();
        Optional<MatchResult> matchResult = Optional.empty();
        Optional<DeterminismAnalysis> determinismAnalysis = Optional.empty();
        DeterminismAnalysisDetails.Builder determinismAnalysisDetails = DeterminismAnalysisDetails.builder();
        Optional<Object> result = Optional.empty();
        try {
            control = Optional.of(this.queryRewriter.rewriteQuery(this.sourceQuery.getControlQuery(), ClusterType.CONTROL));
            test = Optional.of(this.queryRewriter.rewriteQuery(this.sourceQuery.getTestQuery(), ClusterType.TEST));
            QueryBundle controlQueryBundle = control.get();
            QueryBundle testQueryBundle = test.get();
            VerifierUtil.runAndConsume(() -> DataVerificationUtil.setupAndRun(this.prestoAction, controlQueryBundle, false), controlQueryContext::setStats, e -> controlQueryContext.setState(AbstractVerification.getFailingQueryState(e)));
            controlQueryContext.setState(QueryState.SUCCEEDED);
            VerifierUtil.runAndConsume(() -> DataVerificationUtil.setupAndRun(this.prestoAction, testQueryBundle, false), testQueryContext::setStats, e -> testQueryContext.setState(AbstractVerification.getFailingQueryState(e)));
            testQueryContext.setState(QueryState.SUCCEEDED);
            matchResult = Optional.of(this.verify(control.get(), test.get(), controlChecksumQueryContext, testChecksumQueryContext));
            if (matchResult.get().isMismatchPossiblyCausedByNonDeterminism()) {
                determinismAnalysis = Optional.of(this.determinismAnalyzer.analyze(control.get(), matchResult.get().getControlChecksum(), determinismAnalysisDetails));
            }
            result = Optional.of(this.concludeVerification(control, test, controlQueryContext, testQueryContext, matchResult, determinismAnalysis, controlChecksumQueryContext, testChecksumQueryContext, determinismAnalysisDetails.build(), Optional.empty()));
            VerificationResult verificationResult = (VerificationResult)result.get();
            return verificationResult;
        }
        catch (Throwable t) {
            result = Optional.of(this.concludeVerification(control, test, controlQueryContext, testQueryContext, matchResult, determinismAnalysis, controlChecksumQueryContext, testChecksumQueryContext, determinismAnalysisDetails.build(), Optional.of(t)));
            VerificationResult verificationResult = (VerificationResult)result.get();
            return verificationResult;
        }
        finally {
            if (!this.smartTeardown || testQueryContext.getState() != QueryState.SUCCEEDED || result.isPresent() && ((VerificationResult)result.get()).getEvent().map(VerifierQueryEvent::getStatus).map(VerifierQueryEvent.EventStatus::valueOf).equals(Optional.of(VerifierQueryEvent.EventStatus.SUCCEEDED))) {
                DataVerificationUtil.teardownSafely(this.prestoAction, control);
                DataVerificationUtil.teardownSafely(this.prestoAction, test);
            }
        }
    }

    private VerificationResult concludeVerification(Optional<QueryBundle> control, Optional<QueryBundle> test, QueryContext controlQueryContext, QueryContext testQueryContext, Optional<MatchResult> matchResult, Optional<DeterminismAnalysis> determinismAnalysis, ChecksumQueryContext controlChecksumQueryContext, ChecksumQueryContext testChecksumQueryContext, DeterminismAnalysisDetails determinismAnalysisDetails, Optional<Throwable> throwable) {
        if (throwable.isPresent() && PrestoExceptionClassifier.shouldResubmit(throwable.get()) && this.verificationContext.getResubmissionCount() < this.verificationResubmissionLimit) {
            return new VerificationResult(this, true, Optional.empty());
        }
        Optional<SkippedReason> skippedReason = this.getSkippedReason(throwable, controlQueryContext.getState(), determinismAnalysis);
        Optional<String> resolveMessage = Optional.empty();
        if (throwable.isPresent() && controlQueryContext.getState() == QueryState.SUCCEEDED) {
            Preconditions.checkState((boolean)controlQueryContext.getStats().isPresent(), (Object)"controlQueryStats is missing");
            resolveMessage = this.failureResolverManager.resolve(controlQueryContext.getStats().get(), throwable.get(), test);
        }
        VerifierQueryEvent.EventStatus status = skippedReason.isPresent() ? VerifierQueryEvent.EventStatus.SKIPPED : (resolveMessage.isPresent() ? VerifierQueryEvent.EventStatus.FAILED_RESOLVED : (matchResult.isPresent() && matchResult.get().isMatched() ? VerifierQueryEvent.EventStatus.SUCCEEDED : VerifierQueryEvent.EventStatus.FAILED));
        Optional<String> errorCode = Optional.empty();
        Optional<String> errorMessage = Optional.empty();
        if (status != VerifierQueryEvent.EventStatus.SUCCEEDED) {
            errorCode = Optional.ofNullable(throwable.map(t -> t instanceof QueryException ? ((QueryException)t).getErrorCodeName() : INTERNAL_ERROR).orElse(matchResult.map(MatchResult::getMatchType).map(Enum::name).orElse(null)));
            errorMessage = Optional.of(this.constructErrorMessage(throwable, matchResult, controlQueryContext.getState(), testQueryContext.getState()));
        }
        VerifierQueryEvent event = new VerifierQueryEvent(this.sourceQuery.getSuite(), this.testId, this.sourceQuery.getName(), status, skippedReason, determinismAnalysis, determinismAnalysis.isPresent() ? Optional.of(determinismAnalysisDetails) : Optional.empty(), resolveMessage, AbstractVerification.buildQueryInfo(this.sourceQuery.getControlConfiguration(), this.sourceQuery.getControlQuery(), controlChecksumQueryContext, control, controlQueryContext.getStats()), AbstractVerification.buildQueryInfo(this.sourceQuery.getTestConfiguration(), this.sourceQuery.getTestQuery(), testChecksumQueryContext, test, testQueryContext.getStats()), errorCode, errorMessage, throwable.filter(QueryException.class::isInstance).map(QueryException.class::cast).map(QueryException::toQueryFailure), this.verificationContext.getQueryFailures(), this.verificationContext.getResubmissionCount());
        return new VerificationResult(this, false, Optional.of(event));
    }

    private static QueryInfo buildQueryInfo(QueryConfiguration configuration, String originalQuery, ChecksumQueryContext checksumQueryContext, Optional<QueryBundle> queryBundle, Optional<QueryStats> queryStats) {
        return new QueryInfo(configuration.getCatalog(), configuration.getSchema(), originalQuery, queryStats.map(QueryStats::getQueryId), checksumQueryContext.getChecksumQueryId(), queryBundle.map(QueryBundle::getQuery).map(AbstractVerification::formatSql), queryBundle.map(QueryBundle::getSetupQueries).map(AbstractVerification::formatSqls), queryBundle.map(QueryBundle::getTeardownQueries).map(AbstractVerification::formatSqls), checksumQueryContext.getChecksumQuery(), AbstractVerification.millisToSeconds(queryStats.map(QueryStats::getCpuTimeMillis)), AbstractVerification.millisToSeconds(queryStats.map(QueryStats::getWallTimeMillis)));
    }

    protected static String formatSql(Statement statement) {
        return SqlFormatter.formatSql((Node)statement, Optional.empty());
    }

    protected static List<String> formatSqls(List<Statement> statements) {
        return (List)statements.stream().map(AbstractVerification::formatSql).collect(ImmutableList.toImmutableList());
    }

    private Optional<SkippedReason> getSkippedReason(Optional<Throwable> throwable, QueryState controlState, Optional<DeterminismAnalysis> determinismAnalysis) {
        if (throwable.isPresent() && !(throwable.get() instanceof QueryException)) {
            return Optional.of(SkippedReason.VERIFIER_INTERNAL_ERROR);
        }
        switch (controlState) {
            case FAILED: {
                return Optional.of(SkippedReason.CONTROL_QUERY_FAILED);
            }
            case FAILED_TO_SETUP: {
                return Optional.of(SkippedReason.CONTROL_SETUP_QUERY_FAILED);
            }
            case TIMED_OUT: {
                return Optional.of(SkippedReason.CONTROL_QUERY_TIMED_OUT);
            }
            case NOT_RUN: {
                return Optional.of(SkippedReason.FAILED_BEFORE_CONTROL_QUERY);
            }
        }
        if (determinismAnalysis.isPresent() && determinismAnalysis.get().isNonDeterministic()) {
            return Optional.of(SkippedReason.NON_DETERMINISTIC);
        }
        return Optional.empty();
    }

    private static Optional<Double> millisToSeconds(Optional<Long> millis) {
        return millis.map(value -> new Duration((double)value.longValue(), TimeUnit.MILLISECONDS).getValue(TimeUnit.SECONDS));
    }

    private static QueryState getFailingQueryState(QueryException queryException) {
        QueryStage queryStage = queryException.getQueryStage();
        Preconditions.checkArgument((queryStage.isSetup() || queryStage.isMain() ? 1 : 0) != 0, (String)"Expect QueryStage SETUP or MAIN: %s", (Object)((Object)queryStage));
        if (queryStage.isSetup()) {
            return QueryState.FAILED_TO_SETUP;
        }
        return queryException instanceof PrestoQueryException && ((PrestoQueryException)queryException).getErrorCode().equals(Optional.of(StandardErrorCode.EXCEEDED_TIME_LIMIT)) ? QueryState.TIMED_OUT : QueryState.FAILED;
    }

    private String constructErrorMessage(Optional<Throwable> throwable, Optional<MatchResult> matchResult, QueryState controlState, QueryState testState) {
        StringBuilder message = new StringBuilder(String.format("Test state %s, Control state %s.\n\n", new Object[]{testState, controlState}));
        if (throwable.isPresent()) {
            if (throwable.get() instanceof PrestoQueryException) {
                PrestoQueryException exception = (PrestoQueryException)throwable.get();
                message.append(exception.getQueryStage().name().replace("_", " ")).append(" query failed on ").append((Object)exception.getQueryStage().getTargetCluster()).append(" cluster:\n").append(Throwables.getStackTraceAsString((Throwable)exception.getCause()));
            } else {
                message.append(Throwables.getStackTraceAsString((Throwable)throwable.get()));
            }
        }
        matchResult.ifPresent(result -> message.append(result.getResultsComparison()));
        return message.toString();
    }

    private static class QueryContext {
        private Optional<QueryStats> stats = Optional.empty();
        private Optional<QueryState> state = Optional.empty();

        private QueryContext() {
        }

        public Optional<QueryStats> getStats() {
            return this.stats;
        }

        public void setStats(QueryStats stats) {
            Preconditions.checkState((!this.stats.isPresent() ? 1 : 0) != 0, (String)"stats is already set", (Object)stats);
            this.stats = Optional.of(stats);
        }

        public QueryState getState() {
            return this.state.orElse(QueryState.NOT_RUN);
        }

        public void setState(QueryState state) {
            Preconditions.checkState((!this.state.isPresent() ? 1 : 0) != 0, (String)"state is already set", (Object)((Object)state));
            this.state = Optional.of(state);
        }
    }
}

