/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public class RowColumnValidator
implements ColumnValidator {
    private final Map<Column.Category, Provider<ColumnValidator>> columnValidators;

    @Inject
    public RowColumnValidator(Map<Column.Category, Provider<ColumnValidator>> columnValidators) {
        this.columnValidators = columnValidators;
    }

    @Override
    public List<SingleColumn> generateChecksumColumns(Column column) {
        RowColumnValidator.checkColumnType(column);
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        List<RowType.Field> fields = RowColumnValidator.getFields(column);
        for (int i = 0; i < fields.size(); ++i) {
            RowType.Field field = fields.get(i);
            Column fieldColumn = RowColumnValidator.getFieldAsColumn(column, field, i);
            List<SingleColumn> fieldColumns = ((ColumnValidator)this.columnValidators.get((Object)fieldColumn.getCategory()).get()).generateChecksumColumns(fieldColumn);
            columnsBuilder.addAll(fieldColumns);
        }
        return columnsBuilder.build();
    }

    @Override
    public List<ColumnMatchResult> validate(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        RowColumnValidator.checkColumnType(column);
        ImmutableList.Builder resultsBuilder = ImmutableList.builder();
        List<RowType.Field> fields = RowColumnValidator.getFields(column);
        for (int i = 0; i < fields.size(); ++i) {
            Column fieldColumn = RowColumnValidator.getFieldAsColumn(column, fields.get(i), i);
            resultsBuilder.addAll(((ColumnValidator)this.columnValidators.get((Object)fieldColumn.getCategory()).get()).validate(fieldColumn, controlResult, testResult));
        }
        return resultsBuilder.build();
    }

    private static void checkColumnType(Column column) {
        Preconditions.checkArgument((boolean)(column.getType() instanceof RowType), (String)"Expect RowType, found %s", (Object)column.getType().getDisplayName());
    }

    private static List<RowType.Field> getFields(Column column) {
        return ((RowType)column.getType()).getFields();
    }

    private static Column getFieldAsColumn(Column column, RowType.Field field, int fieldIndex) {
        Expression fieldExpression = field.getName().map(name -> new DereferenceExpression(column.getExpression(), VerifierUtil.delimitedIdentifier((String)field.getName().get()))).orElseGet(() -> new SubscriptExpression(column.getExpression(), (Expression)new LongLiteral(String.valueOf(fieldIndex + 1))));
        return Column.create(column.getName() + "." + field.getName().orElse("_col" + (fieldIndex + 1)), fieldExpression, field.getType());
    }
}

