/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class FloatingPointColumnValidator
implements ColumnValidator {
    private final double relativeErrorMargin;
    private final double absoluteErrorMargin;

    @Inject
    public FloatingPointColumnValidator(VerifierConfig config) {
        this.relativeErrorMargin = config.getRelativeErrorMargin();
        this.absoluteErrorMargin = config.getAbsoluteErrorMargin();
    }

    @Override
    public List<SingleColumn> generateChecksumColumns(Column column) {
        Expression doubleColumn = column.getType().equals(DoubleType.DOUBLE) ? column.getExpression() : new Cast(column.getExpression(), DoubleType.DOUBLE.getDisplayName());
        FunctionCall positiveInfinity = new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of());
        ArithmeticUnaryExpression negativeInfinity = new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)positiveInfinity);
        return ImmutableList.of((Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"sum"), Optional.empty(), Optional.of(new FunctionCall(QualifiedName.of((String)"is_finite"), (List)ImmutableList.of((Object)column.getExpression()))), Optional.empty(), false, (List)ImmutableList.of((Object)doubleColumn)), Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getSumColumnAlias(column)))), (Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"count"), Optional.empty(), Optional.of(new FunctionCall(QualifiedName.of((String)"is_nan"), (List)ImmutableList.of((Object)column.getExpression()))), Optional.empty(), false, (List)ImmutableList.of((Object)column.getExpression())), Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getNanCountColumnAlias(column)))), (Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"count"), Optional.empty(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, column.getExpression(), (Expression)positiveInfinity)), Optional.empty(), false, (List)ImmutableList.of((Object)column.getExpression())), Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getPositiveInfinityCountColumnAlias(column)))), (Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"count"), Optional.empty(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, column.getExpression(), (Expression)negativeInfinity)), Optional.empty(), false, (List)ImmutableList.of((Object)column.getExpression())), Optional.of(VerifierUtil.delimitedIdentifier(FloatingPointColumnValidator.getNegativeInfinityCountColumnAlias(column)))));
    }

    @Override
    public List<ColumnMatchResult> validate(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        Preconditions.checkArgument((controlResult.getRowCount() == testResult.getRowCount() ? 1 : 0) != 0, (String)"Test row count (%s) does not match control row count (%s)", (long)testResult.getRowCount(), (long)controlResult.getRowCount());
        String sumColumnAlias = FloatingPointColumnValidator.getSumColumnAlias(column);
        String nanCountColumnAlias = FloatingPointColumnValidator.getNanCountColumnAlias(column);
        String positiveInfinityCountColumnAlias = FloatingPointColumnValidator.getPositiveInfinityCountColumnAlias(column);
        String negativeInfinityCountColumnAlias = FloatingPointColumnValidator.getNegativeInfinityCountColumnAlias(column);
        long controlNanCount = (Long)controlResult.getChecksum(nanCountColumnAlias);
        long testNanCount = (Long)testResult.getChecksum(nanCountColumnAlias);
        long controlPositiveInfinityCount = (Long)controlResult.getChecksum(positiveInfinityCountColumnAlias);
        long testPositiveInfinityCount = (Long)testResult.getChecksum(positiveInfinityCountColumnAlias);
        long controlNegativeInfinityCount = (Long)controlResult.getChecksum(negativeInfinityCountColumnAlias);
        long testNegativeInfinityCount = (Long)testResult.getChecksum(negativeInfinityCountColumnAlias);
        if (!(Objects.equals(controlNanCount, testNanCount) && Objects.equals(controlPositiveInfinityCount, testPositiveInfinityCount) && Objects.equals(controlNegativeInfinityCount, testNegativeInfinityCount))) {
            return ImmutableList.of((Object)new ColumnMatchResult(false, column, String.format("control(NaN: %s, +infinity: %s, -infinity: %s) test(NaN: %s, +infinity: %s, -infinity: %s)", controlNanCount, controlPositiveInfinityCount, controlNegativeInfinityCount, testNanCount, testPositiveInfinityCount, testNegativeInfinityCount)));
        }
        Object controlSumObject = controlResult.getChecksum(sumColumnAlias);
        Object testSumObject = testResult.getChecksum(sumColumnAlias);
        if (controlSumObject == null || testSumObject == null) {
            return ImmutableList.of((Object)new ColumnMatchResult(controlSumObject == null && testSumObject == null, column, String.format("control(sum: %s) test(sum: %s)", controlSumObject, testSumObject)));
        }
        double controlSum = (Double)controlSumObject;
        double testSum = (Double)testSumObject;
        if (Double.isNaN(controlSum) || Double.isNaN(testSum) || Double.isInfinite(controlSum) || Double.isInfinite(testSum)) {
            return ImmutableList.of((Object)new ColumnMatchResult(false, column, String.format("control(sum: %s) test(sum: %s)", controlSum, testSum)));
        }
        double controlMean = controlSum / (double)controlResult.getRowCount();
        double testMean = testSum / (double)controlResult.getRowCount();
        if (Math.abs(controlMean) < this.absoluteErrorMargin || Math.abs(testMean) < this.absoluteErrorMargin) {
            return ImmutableList.of((Object)new ColumnMatchResult(Math.abs(controlMean) < this.absoluteErrorMargin && Math.abs(testMean) < this.absoluteErrorMargin, column, String.format("control(mean: %s) test(mean: %s)", controlMean, testMean)));
        }
        double difference = Math.abs(controlSum - testSum);
        double relativeError = difference / Math.min((Math.abs(controlSum) + Math.abs(testSum)) / 2.0, Double.MAX_VALUE);
        return ImmutableList.of((Object)new ColumnMatchResult(relativeError < this.relativeErrorMargin, column, String.format("control(sum: %s) test(sum: %s) relative error: %s", controlSum, testSum, relativeError)));
    }

    private static String getSumColumnAlias(Column column) {
        return column.getName() + "$sum";
    }

    private static String getNanCountColumnAlias(Column column) {
        return column.getName() + "$nan_count";
    }

    private static String getPositiveInfinityCountColumnAlias(Column column) {
        return column.getName() + "$pos_inf_count";
    }

    private static String getNegativeInfinityCountColumnAlias(Column column) {
        return column.getName() + "$neg_inf_count";
    }
}

