/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.framework.Column;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Provider;

public class ChecksumValidator {
    private final Map<Column.Category, Provider<ColumnValidator>> columnValidators;

    @Inject
    public ChecksumValidator(Map<Column.Category, Provider<ColumnValidator>> columnValidators) {
        this.columnValidators = columnValidators;
    }

    public Query generateChecksumQuery(QualifiedName tableName, List<Column> columns) {
        ImmutableList.Builder selectItems = ImmutableList.builder();
        selectItems.add((Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of())));
        for (Column column : columns) {
            selectItems.addAll(((ColumnValidator)this.columnValidators.get((Object)column.getCategory()).get()).generateChecksumColumns(column));
        }
        return QueryUtil.simpleQuery((Select)new Select(false, (List)selectItems.build()), (Relation)new Table(tableName));
    }

    public Map<Column, ColumnMatchResult> getMismatchedColumns(List<Column> columns, ChecksumResult controlChecksum, ChecksumResult testChecksum) {
        return (Map)((ImmutableMap)columns.stream().flatMap(column -> ((ColumnValidator)this.columnValidators.get((Object)column.getCategory()).get()).validate((Column)column, controlChecksum, testChecksum).stream()).collect(ImmutableMap.toImmutableMap(ColumnMatchResult::getColumn, Function.identity()))).entrySet().stream().filter(entry -> !((ColumnMatchResult)entry.getValue()).isMatched()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

