/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.spi.type.SqlVarbinary;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ChecksumResult {
    private final long rowCount;
    private final Map<String, Object> checksums;

    public ChecksumResult(long rowCount, Map<String, Object> checksums) {
        this.rowCount = rowCount;
        this.checksums = Collections.unmodifiableMap(Objects.requireNonNull(checksums, "checksums is null"));
        for (Object checksum : checksums.values()) {
            Preconditions.checkArgument((checksum == null || checksum instanceof Long || checksum instanceof Double || checksum instanceof SqlVarbinary ? 1 : 0) != 0, (String)"checksum can only be one of (null, Long, Double, SqlVarbinary), found %s", (Object)(checksum == null ? "null" : checksum.getClass().getName()));
        }
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public Object getChecksum(String columnName) {
        Preconditions.checkArgument((boolean)this.checksums.containsKey(columnName), (String)"column does not exist: %s", (Object)columnName);
        return this.checksums.get(columnName);
    }

    public static Optional<ChecksumResult> fromResultSet(ResultSet resultSet) throws SQLException {
        long rowCount = resultSet.getLong(1);
        ResultSetMetaData metaData = resultSet.getMetaData();
        HashMap<String, Object> checksums = new HashMap<String, Object>(metaData.getColumnCount());
        for (int i = 2; i <= metaData.getColumnCount(); ++i) {
            String columnName = metaData.getColumnName(i);
            Object checksum = resultSet.getObject(i);
            if (checksum == null) {
                checksums.put(columnName, null);
                continue;
            }
            if (metaData.getColumnType(i) == 8) {
                Preconditions.checkState((boolean)(checksum instanceof Double), (String)"Expecting double for column %s, found %s", (Object)columnName, checksum.getClass());
                checksums.put(columnName, checksum);
                continue;
            }
            if (metaData.getColumnType(i) == -5) {
                Preconditions.checkState((boolean)(checksum instanceof Long), (String)"Expecting bigint for column %s, found %s", (Object)columnName, checksum.getClass());
                checksums.put(columnName, checksum);
                continue;
            }
            Preconditions.checkState((boolean)(checksum instanceof byte[]), (String)"Expecting binary for column %s, found %s", (Object)columnName, checksum.getClass());
            checksums.put(columnName, new SqlVarbinary((byte[])checksum));
        }
        return Optional.of(new ChecksumResult(rowCount, checksums));
    }
}

