/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ArrayColumnValidator
implements ColumnValidator {
    @Override
    public List<SingleColumn> generateChecksumColumns(Column column) {
        Expression checksum = ArrayColumnValidator.generateArrayChecksum(column.getExpression(), column.getType());
        CoalesceExpression arrayCardinalitySum = new CoalesceExpression((Expression)new FunctionCall(QualifiedName.of((String)"sum"), (List)ImmutableList.of((Object)new FunctionCall(QualifiedName.of((String)"cardinality"), (List)ImmutableList.of((Object)column.getExpression())))), (Expression)new LongLiteral("0"), new Expression[0]);
        return ImmutableList.of((Object)new SingleColumn(checksum, Optional.of(VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getChecksumColumnAlias(column)))), (Object)new SingleColumn((Expression)arrayCardinalitySum, Optional.of(VerifierUtil.delimitedIdentifier(ArrayColumnValidator.getCardinalitySumColumnAlias(column)))));
    }

    @Override
    public List<ColumnMatchResult> validate(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        String checksumColumnAlias = ArrayColumnValidator.getChecksumColumnAlias(column);
        Object controlChecksum = controlResult.getChecksum(checksumColumnAlias);
        Object testChecksum = testResult.getChecksum(checksumColumnAlias);
        String cardinalitySumColumnAlias = ArrayColumnValidator.getCardinalitySumColumnAlias(column);
        Object controlCardinalitySum = controlResult.getChecksum(cardinalitySumColumnAlias);
        Object testCardinalitySum = testResult.getChecksum(cardinalitySumColumnAlias);
        return ImmutableList.of((Object)new ColumnMatchResult(Objects.equals(controlChecksum, testChecksum) && Objects.equals(controlCardinalitySum, testCardinalitySum), column, String.format("control(checksum: %s, cardinality_sum: %s) test(checksum: %s, cardinality_sum: %s)", controlChecksum, controlCardinalitySum, testChecksum, testCardinalitySum)));
    }

    public static Expression generateArrayChecksum(Expression column, Type type) {
        Preconditions.checkArgument((boolean)(type instanceof ArrayType), (String)"Expect ArrayType, found %s", (Object)type.getDisplayName());
        Type elementType = ((ArrayType)type).getElementType();
        if (elementType.isOrderable()) {
            FunctionCall arraySort = new FunctionCall(QualifiedName.of((String)"array_sort"), (List)ImmutableList.of((Object)column));
            if (elementType instanceof ArrayType || elementType instanceof RowType) {
                return new CoalesceExpression((Expression)new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)new TryExpression((Expression)arraySort))), (Expression)new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)column)), new Expression[0]);
            }
            return new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)arraySort));
        }
        return new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)column));
    }

    private static String getChecksumColumnAlias(Column column) {
        return column.getName() + "$checksum";
    }

    private static String getCardinalitySumColumnAlias(Column column) {
        return column.getName() + "$cardinality_sum";
    }
}

