/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.retry;

import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.retry.RetryConfig;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class RetryDriver {
    private static final Logger log = Logger.get(RetryDriver.class);
    private final int maxAttempts;
    private final Duration minBackoffDelay;
    private final Duration maxBackoffDelay;
    private final double scaleFactor;
    private final Predicate<QueryException> retryPredicate;

    public RetryDriver(RetryConfig config, Predicate<QueryException> retryPredicate) {
        this.maxAttempts = config.getMaxAttempts();
        this.minBackoffDelay = Objects.requireNonNull(config.getMinBackoffDelay(), "minBackoffDelay is null");
        this.maxBackoffDelay = Objects.requireNonNull(config.getMaxBackoffDelay(), "maxBackoffDelay is null");
        this.scaleFactor = config.getScaleFactor();
        this.retryPredicate = Objects.requireNonNull(retryPredicate, "retryPredicate is null");
    }

    public <V> V run(String callableName, VerificationContext context, RetryOperation<V> operation) {
        int attempt = 1;
        while (true) {
            try {
                return operation.run();
            }
            catch (QueryException qe) {
                context.recordFailure(qe);
                if (attempt >= this.maxAttempts || !this.retryPredicate.test(qe)) {
                    throw qe;
                }
                int delayMillis = (int)Math.min((double)this.minBackoffDelay.toMillis() * Math.pow(this.scaleFactor, ++attempt - 1), (double)this.maxBackoffDelay.toMillis());
                int jitterMillis = ThreadLocalRandom.current().nextInt(Math.max(1, (int)((double)delayMillis * 0.1)));
                log.debug("Failed on executing %s(%s, %s) with attempt %d. Retry after %sms. Cause: %s", new Object[]{callableName, qe.getQueryOrigin().getCluster(), qe.getQueryOrigin().getStage(), attempt - 1, delayMillis, qe.getErrorCode()});
                try {
                    TimeUnit.MILLISECONDS.sleep(delayMillis + jitterMillis);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
            }
        }
    }

    public static interface RetryOperation<V> {
        public V run() throws QueryException;
    }
}

