/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryOrigin;
import com.facebook.presto.verifier.resolver.FailureResolver;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractPrestoQueryFailureResolver
implements FailureResolver {
    private QueryOrigin expectedQueryOrigin;

    public AbstractPrestoQueryFailureResolver(QueryOrigin expectedQueryOrigin) {
        this.expectedQueryOrigin = Objects.requireNonNull(expectedQueryOrigin, "expectedQueryOrigin is null");
    }

    public abstract Optional<String> resolveTestQueryFailure(ErrorCodeSupplier var1, QueryStats var2, QueryStats var3);

    @Override
    public Optional<String> resolve(QueryStats controlQueryStats, QueryException queryException) {
        if (!(queryException.getQueryOrigin().equals(this.expectedQueryOrigin) && queryException.getType() == QueryException.Type.PRESTO && queryException.getPrestoErrorCode().isPresent() && queryException.getQueryStats().isPresent())) {
            return Optional.empty();
        }
        return this.resolveTestQueryFailure(queryException.getPrestoErrorCode().get(), controlQueryStats, queryException.getQueryStats().get());
    }
}

