/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.checksum.FloatingPointColumnValidator;
import com.facebook.presto.verifier.checksum.OrderableArrayColumnValidator;
import com.facebook.presto.verifier.checksum.SimpleColumnValidator;
import com.facebook.presto.verifier.framework.PrestoAction;
import com.facebook.presto.verifier.framework.QueryRewriter;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.SqlExceptionClassifier;
import com.facebook.presto.verifier.framework.VerificationFactory;
import com.facebook.presto.verifier.framework.VerificationManager;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.resolver.FailureResolver;
import com.facebook.presto.verifier.retry.ForClusterConnection;
import com.facebook.presto.verifier.retry.ForPresto;
import com.facebook.presto.verifier.retry.RetryConfig;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Provider;

public class VerifierModule
extends AbstractConfigurationAwareModule {
    private final SqlParserOptions sqlParserOptions;
    private final List<Class<? extends Predicate<SourceQuery>>> customQueryFilterClasses;
    private final SqlExceptionClassifier exceptionClassifier;
    private final List<FailureResolver> failureResolvers;

    public VerifierModule(SqlParserOptions sqlParserOptions, List<Class<? extends Predicate<SourceQuery>>> customQueryFilterClasses, SqlExceptionClassifier exceptionClassifier, List<FailureResolver> failureResolvers) {
        this.sqlParserOptions = Objects.requireNonNull(sqlParserOptions, "sqlParserOptions is null");
        this.customQueryFilterClasses = ImmutableList.copyOf(customQueryFilterClasses);
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.failureResolvers = Objects.requireNonNull(failureResolvers, "failureResolvers is null");
    }

    protected final void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(VerifierConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(RetryConfig.class, ForClusterConnection.class, "cluster-connection");
        ConfigBinder.configBinder((Binder)binder).bindConfig(RetryConfig.class, ForPresto.class, "presto");
        for (Class<? extends Predicate<SourceQuery>> customQueryFilterClass : this.customQueryFilterClasses) {
            binder.bind(customQueryFilterClass).in(Scopes.SINGLETON);
        }
        binder.bind(SqlParserOptions.class).toInstance((Object)this.sqlParserOptions);
        binder.bind(SqlParser.class).in(Scopes.SINGLETON);
        binder.bind(QueryRewriter.class).in(Scopes.SINGLETON);
        binder.bind(PrestoAction.class).in(Scopes.SINGLETON);
        binder.bind(VerificationManager.class).in(Scopes.SINGLETON);
        binder.bind(VerificationFactory.class).in(Scopes.SINGLETON);
        binder.bind(ChecksumValidator.class).in(Scopes.SINGLETON);
        binder.bind(SimpleColumnValidator.class).in(Scopes.SINGLETON);
        binder.bind(FloatingPointColumnValidator.class).in(Scopes.SINGLETON);
        binder.bind(OrderableArrayColumnValidator.class).in(Scopes.SINGLETON);
        binder.bind((TypeLiteral)new TypeLiteral<List<Predicate<SourceQuery>>>(){}).toProvider((Provider)new CustomQueryFilterProvider(this.customQueryFilterClasses));
        binder.bind(SqlExceptionClassifier.class).toInstance((Object)this.exceptionClassifier);
        binder.bind((TypeLiteral)new TypeLiteral<List<FailureResolver>>(){}).toInstance(this.failureResolvers);
    }

    private static class CustomQueryFilterProvider
    implements Provider<List<Predicate<SourceQuery>>> {
        private final List<Class<? extends Predicate<SourceQuery>>> customQueryFilterClasses;
        private Injector injector;

        public CustomQueryFilterProvider(List<Class<? extends Predicate<SourceQuery>>> customQueryFilterClasses) {
            this.customQueryFilterClasses = ImmutableList.copyOf(customQueryFilterClasses);
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public List<Predicate<SourceQuery>> get() {
            ImmutableList.Builder customVerificationFilters = ImmutableList.builder();
            for (Class<? extends Predicate<SourceQuery>> filterClass : this.customQueryFilterClasses) {
                customVerificationFilters.add(this.injector.getInstance(filterClass));
            }
            return customVerificationFilters.build();
        }
    }
}

