/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class VerifierConfig {
    private Optional<String> additionalJdbcDriverPath = Optional.empty();
    private Optional<String> controlJdbcDriverClass = Optional.empty();
    private Optional<String> testJdbcDriverClass = Optional.empty();
    private String controlJdbcUrl;
    private String testJdbcUrl;
    private Duration controlTimeout = new Duration(10.0, TimeUnit.MINUTES);
    private Duration testTimeout = new Duration(30.0, TimeUnit.MINUTES);
    private Duration metadataTimeout = new Duration(3.0, TimeUnit.MINUTES);
    private Duration checksumTimeout = new Duration(20.0, TimeUnit.MINUTES);
    private QualifiedName controlTablePrefix = QualifiedName.of((String)"tmp_verifier_control");
    private QualifiedName testTablePrefix = QualifiedName.of((String)"tmp_verifier_test");
    private Optional<String> controlCatalogOverride = Optional.empty();
    private Optional<String> controlSchemaOverride = Optional.empty();
    private Optional<String> controlUsernameOverride = Optional.empty();
    private Optional<String> controlPasswordOverride = Optional.empty();
    private Optional<String> testCatalogOverride = Optional.empty();
    private Optional<String> testSchemaOverride = Optional.empty();
    private Optional<String> testUsernameOverride = Optional.empty();
    private Optional<String> testPasswordOverride = Optional.empty();
    private Optional<Set<String>> whitelist = Optional.empty();
    private Optional<Set<String>> blacklist = Optional.empty();
    private String sourceQuerySupplier = "mysql";
    private Set<String> eventClients = ImmutableSet.of((Object)"human-readable");
    private Optional<String> jsonEventLogFile = Optional.empty();
    private Optional<String> humanReadableEventLogFile = Optional.empty();
    private String testId;
    private int maxConcurrency = 10;
    private int suiteRepetitions = 1;
    private int queryRepetitions = 1;
    private double relativeErrorMargin = 1.0E-4;
    private double absoluteErrorMargin = 1.0E-12;
    private boolean runTearDownOnResultMismatch;
    private boolean failureResolverEnabled = true;

    @NotNull
    public Optional<String> getAdditionalJdbcDriverPath() {
        return this.additionalJdbcDriverPath;
    }

    @ConfigDescription(value="Path for test jdbc driver")
    @Config(value="additional-jdbc-driver-path")
    public VerifierConfig setAdditionalJdbcDriverPath(String additionalJdbcDriverPath) {
        this.additionalJdbcDriverPath = Optional.ofNullable(additionalJdbcDriverPath);
        return this;
    }

    @NotNull
    public Optional<String> getControlJdbcDriverClass() {
        return this.controlJdbcDriverClass;
    }

    @ConfigDescription(value="Fully qualified control JDBC driver name")
    @Config(value="control.jdbc-driver-class")
    public VerifierConfig setControlJdbcDriverClass(String controlJdbcDriverClass) {
        this.controlJdbcDriverClass = Optional.ofNullable(controlJdbcDriverClass);
        return this;
    }

    @NotNull
    public Optional<String> getTestJdbcDriverClass() {
        return this.testJdbcDriverClass;
    }

    @ConfigDescription(value="Fully qualified test JDBC driver name")
    @Config(value="test.jdbc-driver-class")
    public VerifierConfig setTestJdbcDriverClass(String testJdbcDriverClass) {
        this.testJdbcDriverClass = Optional.ofNullable(testJdbcDriverClass);
        return this;
    }

    @NotNull
    public String getControlJdbcUrl() {
        return this.controlJdbcUrl;
    }

    @ConfigDescription(value="URL for the control cluster")
    @Config(value="control.jdbc-url")
    public VerifierConfig setControlJdbcUrl(String controlJdbcUrl) {
        this.controlJdbcUrl = controlJdbcUrl;
        return this;
    }

    @NotNull
    public String getTestJdbcUrl() {
        return this.testJdbcUrl;
    }

    @ConfigDescription(value="URL for the test cluster")
    @Config(value="test.jdbc-url")
    public VerifierConfig setTestJdbcUrl(String testJdbcUrl) {
        this.testJdbcUrl = testJdbcUrl;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getControlTimeout() {
        return this.controlTimeout;
    }

    @ConfigDescription(value="Timeout for queries to the control cluster")
    @Config(value="control.timeout")
    public VerifierConfig setControlTimeout(Duration controlTimeout) {
        this.controlTimeout = controlTimeout;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getTestTimeout() {
        return this.testTimeout;
    }

    @ConfigDescription(value="Timeout for queries to the test cluster")
    @Config(value="test.timeout")
    public VerifierConfig setTestTimeout(Duration testTimeout) {
        this.testTimeout = testTimeout;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getMetadataTimeout() {
        return this.metadataTimeout;
    }

    @Config(value="metadata.timeout")
    public VerifierConfig setMetadataTimeout(Duration metadataTimeout) {
        this.metadataTimeout = metadataTimeout;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getChecksumTimeout() {
        return this.checksumTimeout;
    }

    @Config(value="checksum.timeout")
    public VerifierConfig setChecksumTimeout(Duration checksumTimeout) {
        this.checksumTimeout = checksumTimeout;
        return this;
    }

    @NotNull
    public QualifiedName getControlTablePrefix() {
        return this.controlTablePrefix;
    }

    @ConfigDescription(value="The prefix to use for temporary control shadow tables. May be fully qualified like 'tmp_catalog.tmp_schema.tmp_'")
    @Config(value="control.table-prefix")
    public VerifierConfig setControlTablePrefix(String controlTablePrefix) {
        this.controlTablePrefix = controlTablePrefix == null ? null : QualifiedName.of((Iterable)Splitter.on((String)".").splitToList((CharSequence)controlTablePrefix));
        return this;
    }

    @NotNull
    public QualifiedName getTestTablePrefix() {
        return this.testTablePrefix;
    }

    @ConfigDescription(value="The prefix to use for temporary test shadow tables. May be fully qualified like 'tmp_catalog.tmp_schema.tmp_'")
    @Config(value="test.table-prefix")
    public VerifierConfig setTestTablePrefix(String testTablePrefix) {
        this.testTablePrefix = testTablePrefix == null ? null : QualifiedName.of((Iterable)Splitter.on((String)".").splitToList((CharSequence)testTablePrefix));
        return this;
    }

    public Optional<String> getControlCatalogOverride() {
        return this.controlCatalogOverride;
    }

    @ConfigDescription(value="Overrides the control_catalog field in all queries in the suites")
    @Config(value="control.catalog-override")
    public VerifierConfig setControlCatalogOverride(String controlCatalogOverride) {
        this.controlCatalogOverride = Optional.ofNullable(controlCatalogOverride);
        return this;
    }

    public Optional<String> getControlSchemaOverride() {
        return this.controlSchemaOverride;
    }

    @ConfigDescription(value="Overrides the control_schema field in all queries in the suites")
    @Config(value="control.schema-override")
    public VerifierConfig setControlSchemaOverride(String controlSchemaOverride) {
        this.controlSchemaOverride = Optional.ofNullable(controlSchemaOverride);
        return this;
    }

    @NotNull
    public Optional<String> getControlUsernameOverride() {
        return this.controlUsernameOverride;
    }

    @ConfigDescription(value="Username for control cluster")
    @Config(value="control.username-override")
    public VerifierConfig setControlUsernameOverride(String controlUsernameOverride) {
        this.controlUsernameOverride = Optional.ofNullable(controlUsernameOverride);
        return this;
    }

    @NotNull
    public Optional<String> getControlPasswordOverride() {
        return this.controlPasswordOverride;
    }

    @ConfigDescription(value="Password for control cluster")
    @Config(value="control.password-override")
    public VerifierConfig setControlPasswordOverride(String controlPasswordOverride) {
        this.controlPasswordOverride = Optional.ofNullable(controlPasswordOverride);
        return this;
    }

    public Optional<String> getTestCatalogOverride() {
        return this.testCatalogOverride;
    }

    @ConfigDescription(value="Overrides the test_catalog field in all queries in the suites")
    @Config(value="test.catalog-override")
    public VerifierConfig setTestCatalogOverride(String testCatalogOverride) {
        this.testCatalogOverride = Optional.ofNullable(testCatalogOverride);
        return this;
    }

    public Optional<String> getTestSchemaOverride() {
        return this.testSchemaOverride;
    }

    @ConfigDescription(value="Overrides the test_schema field in all queries in the suites")
    @Config(value="test.schema-override")
    public VerifierConfig setTestSchemaOverride(String testSchemaOverride) {
        this.testSchemaOverride = Optional.ofNullable(testSchemaOverride);
        return this;
    }

    @NotNull
    public Optional<String> getTestUsernameOverride() {
        return this.testUsernameOverride;
    }

    @ConfigDescription(value="Username for test cluster")
    @Config(value="test.username-override")
    public VerifierConfig setTestUsernameOverride(String testUsernameOverride) {
        this.testUsernameOverride = Optional.ofNullable(testUsernameOverride);
        return this;
    }

    @NotNull
    public Optional<String> getTestPasswordOverride() {
        return this.testPasswordOverride;
    }

    @ConfigDescription(value="Password for test cluster")
    @Config(value="test.password-override")
    public VerifierConfig setTestPasswordOverride(String testPasswordOverride) {
        this.testPasswordOverride = Optional.ofNullable(testPasswordOverride);
        return this;
    }

    @NotNull
    public Optional<Set<String>> getWhitelist() {
        return this.whitelist;
    }

    @ConfigDescription(value="Names of queries which are whitelisted. Whitelist is applied before the blacklist")
    @Config(value="whitelist")
    public VerifierConfig setWhitelist(String whitelist) {
        this.whitelist = whitelist == null ? Optional.empty() : Optional.of(ImmutableSet.copyOf((Collection)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)whitelist)));
        return this;
    }

    @NotNull
    public Optional<Set<String>> getBlacklist() {
        return this.blacklist;
    }

    @ConfigDescription(value="Names of queries which are blacklisted")
    @Config(value="blacklist")
    public VerifierConfig setBlacklist(String blacklist) {
        this.blacklist = blacklist == null ? Optional.empty() : Optional.of(ImmutableSet.copyOf((Collection)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)blacklist)));
        return this;
    }

    @NotNull
    public String getSourceQuerySupplier() {
        return this.sourceQuerySupplier;
    }

    @ConfigDescription(value="The type of source query supplier")
    @Config(value="source-query.supplier")
    public VerifierConfig setSourceQuerySupplier(String sourceQuerySupplier) {
        this.sourceQuerySupplier = sourceQuerySupplier;
        return this;
    }

    @NotNull
    public Set<String> getEventClients() {
        return this.eventClients;
    }

    @ConfigDescription(value="The event client(s) to log the results to")
    @Config(value="event-clients")
    public VerifierConfig setEventClients(String eventClients) {
        this.eventClients = ImmutableSet.copyOf((Collection)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)eventClients));
        return this;
    }

    @NotNull
    public Optional<String> getJsonEventLogFile() {
        return this.jsonEventLogFile;
    }

    @ConfigDescription(value="The file to log json events. Used with event-clients=json. Print to standard output stream if not specified.")
    @Config(value="json.log-file")
    public VerifierConfig setJsonEventLogFile(String jsonEventLogFile) {
        this.jsonEventLogFile = Optional.ofNullable(jsonEventLogFile);
        return this;
    }

    @NotNull
    public Optional<String> getHumanReadableEventLogFile() {
        return this.humanReadableEventLogFile;
    }

    @ConfigDescription(value="The file to log human readable events. Used with event-clients=human-readable. Print to standard output stream if not specified.")
    @Config(value="human-readable.log-file")
    public VerifierConfig setHumanReadableEventLogFile(String humanReadableEventLogFile) {
        this.humanReadableEventLogFile = Optional.ofNullable(humanReadableEventLogFile);
        return this;
    }

    @NotNull
    public String getTestId() {
        return this.testId;
    }

    @ConfigDescription(value="A customizable string that will be logged with the results")
    @Config(value="test-id")
    public VerifierConfig setTestId(String testId) {
        this.testId = testId;
        return this;
    }

    @Min(value=1L)
    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    @Config(value="max-concurrency")
    public VerifierConfig setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    @Min(value=1L)
    public int getSuiteRepetitions() {
        return this.suiteRepetitions;
    }

    @ConfigDescription(value="Number of times to run each suite")
    @Config(value="suite-repetitions")
    public VerifierConfig setSuiteRepetitions(int suiteRepetitions) {
        this.suiteRepetitions = suiteRepetitions;
        return this;
    }

    @Min(value=1L)
    public int getQueryRepetitions() {
        return this.queryRepetitions;
    }

    @ConfigDescription(value="The number of times to repeat each query")
    @Config(value="query-repetitions")
    public VerifierConfig setQueryRepetitions(int queryRepetitions) {
        this.queryRepetitions = queryRepetitions;
        return this;
    }

    @Min(value=0L)
    public double getRelativeErrorMargin() {
        return this.relativeErrorMargin;
    }

    @ConfigDescription(value="The maximum tolerable relative error between the sum of two floating point columns.")
    @Config(value="relative-error-margin")
    public VerifierConfig setRelativeErrorMargin(double relativeErrorMargin) {
        this.relativeErrorMargin = relativeErrorMargin;
        return this;
    }

    @Min(value=0L)
    public double getAbsoluteErrorMargin() {
        return this.absoluteErrorMargin;
    }

    @ConfigDescription(value="The maximum tolerable difference between the mean of two floating point columns. Applicable when one mean value is 0.")
    @Config(value="absolute-error-margin")
    public VerifierConfig setAbsoluteErrorMargin(double absoluteErrorMargin) {
        this.absoluteErrorMargin = absoluteErrorMargin;
        return this;
    }

    public boolean isRunTearDownOnResultMismatch() {
        return this.runTearDownOnResultMismatch;
    }

    @ConfigDescription(value="When set to false, temporary tables are not dropped in case of checksum failure")
    @Config(value="run-teardown-on-result-mismatch")
    public VerifierConfig setRunTearDownOnResultMismatch(boolean runTearDownOnResultMismatch) {
        this.runTearDownOnResultMismatch = runTearDownOnResultMismatch;
        return this;
    }

    public boolean isFailureResolverEnabled() {
        return this.failureResolverEnabled;
    }

    @Config(value="failure-resolver.enabled")
    public VerifierConfig setFailureResolverEnabled(boolean failureResolverEnabled) {
        this.failureResolverEnabled = failureResolverEnabled;
        return this;
    }
}

