/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.verifier.event.VerifierQueryEvent;
import com.facebook.presto.verifier.framework.JdbcDriverUtil;
import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.facebook.presto.verifier.framework.QueryType;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.UnsupportedQueryTypeException;
import com.facebook.presto.verifier.framework.Verification;
import com.facebook.presto.verifier.framework.VerificationFactory;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.source.SourceQuerySupplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.event.client.EventClient;
import io.airlift.log.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class VerificationManager {
    private static final Logger log = Logger.get(VerificationManager.class);
    private final SourceQuerySupplier sourceQuerySupplier;
    private final VerificationFactory verificationFactory;
    private final SqlParser sqlParser;
    private final Set<EventClient> eventClients;
    private final List<Predicate<SourceQuery>> customQueryFilters;
    private final Optional<String> additionalJdbcDriverPath;
    private final Optional<String> controlJdbcDriverClass;
    private final Optional<String> testJdbcDriverClass;
    private final Optional<String> controlCatalogOverride;
    private final Optional<String> controlSchemaOverride;
    private final Optional<String> controlUsernameOverride;
    private final Optional<String> controlPasswordOverride;
    private final Optional<String> testCatalogOverride;
    private final Optional<String> testSchemaOverride;
    private final Optional<String> testUsernameOverride;
    private final Optional<String> testPasswordOverride;
    private final Optional<Set<String>> whitelist;
    private final Optional<Set<String>> blacklist;
    private final int maxConcurrency;
    private final int suiteRepetitions;
    private final int queryRepetitions;

    @Inject
    public VerificationManager(SourceQuerySupplier sourceQuerySupplier, VerificationFactory verificationFactory, SqlParser sqlParser, Set<EventClient> eventClients, List<Predicate<SourceQuery>> customQueryFilters, VerifierConfig config) {
        this.sourceQuerySupplier = Objects.requireNonNull(sourceQuerySupplier, "sourceQuerySupplier is null");
        this.verificationFactory = Objects.requireNonNull(verificationFactory, "verificationFactory is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.eventClients = ImmutableSet.copyOf(eventClients);
        this.customQueryFilters = Objects.requireNonNull(customQueryFilters, "customQueryFilters is null");
        this.additionalJdbcDriverPath = Objects.requireNonNull(config.getAdditionalJdbcDriverPath(), "additionalJdbcDriverPath is null");
        this.controlJdbcDriverClass = Objects.requireNonNull(config.getControlJdbcDriverClass(), "controlJdbcDriverClass is null");
        this.testJdbcDriverClass = Objects.requireNonNull(config.getTestJdbcDriverClass(), "testJdbcDriverClass is null");
        this.controlCatalogOverride = Objects.requireNonNull(config.getControlCatalogOverride(), "controlCatalogOverride is null");
        this.controlSchemaOverride = Objects.requireNonNull(config.getControlSchemaOverride(), "controlSchemaOverride is null");
        this.controlUsernameOverride = Objects.requireNonNull(config.getControlUsernameOverride(), "controlUsernameOverride is null");
        this.controlPasswordOverride = Objects.requireNonNull(config.getControlPasswordOverride(), "controlPasswordOverride is null");
        this.testCatalogOverride = Objects.requireNonNull(config.getTestCatalogOverride(), "testCatalogOverride is null");
        this.testSchemaOverride = Objects.requireNonNull(config.getTestSchemaOverride(), "testSchemaOverride is null");
        this.testUsernameOverride = Objects.requireNonNull(config.getTestUsernameOverride(), "testUsernameOverride is null");
        this.testPasswordOverride = Objects.requireNonNull(config.getTestPasswordOverride(), "testPasswordOverride is null");
        this.whitelist = Objects.requireNonNull(config.getWhitelist(), "whitelist is null");
        this.blacklist = Objects.requireNonNull(config.getBlacklist(), "blacklist is null");
        this.maxConcurrency = config.getMaxConcurrency();
        this.suiteRepetitions = config.getSuiteRepetitions();
        this.queryRepetitions = config.getQueryRepetitions();
    }

    public void start() {
        JdbcDriverUtil.initializeDrivers(this.additionalJdbcDriverPath, this.controlJdbcDriverClass, this.testJdbcDriverClass);
        List<SourceQuery> sourceQueries = (List<SourceQuery>)this.sourceQuerySupplier.get();
        log.info("Total Queries: %s", new Object[]{sourceQueries.size()});
        sourceQueries = this.applyOverrides(sourceQueries);
        sourceQueries = this.applyWhitelist(sourceQueries);
        sourceQueries = this.applyBlacklist(sourceQueries);
        sourceQueries = this.filterQueryType(sourceQueries);
        sourceQueries = this.applyCustomFilters(sourceQueries);
        CompletionService<Optional<VerifierQueryEvent>> completionService = this.submitSourceQueriesForVerification(sourceQueries);
        int queriesSubmitted = sourceQueries.size() * this.suiteRepetitions * this.queryRepetitions;
        log.info("Queries submitted: %s", new Object[]{queriesSubmitted});
        this.reportProgressUntilFinished(completionService, queriesSubmitted);
    }

    @PreDestroy
    public void close() {
        for (EventClient eventClient : this.eventClients) {
            if (!(eventClient instanceof Closeable)) continue;
            try {
                ((Closeable)eventClient).close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    private List<SourceQuery> applyOverrides(List<SourceQuery> sourceQueries) {
        return (List)sourceQueries.stream().map(sourceQuery -> new SourceQuery(sourceQuery.getSuite(), sourceQuery.getName(), sourceQuery.getControlQuery(), sourceQuery.getTestQuery(), new QueryConfiguration(this.testCatalogOverride.orElse(sourceQuery.getTestConfiguration().getCatalog()), this.testSchemaOverride.orElse(sourceQuery.getTestConfiguration().getSchema()), this.testUsernameOverride.orElse(sourceQuery.getTestConfiguration().getUsername()), Optional.ofNullable(this.testPasswordOverride.orElse(sourceQuery.getTestConfiguration().getPassword().orElse(null))), sourceQuery.getTestConfiguration().getSessionProperties()), new QueryConfiguration(this.controlCatalogOverride.orElse(sourceQuery.getControlConfiguration().getCatalog()), this.controlSchemaOverride.orElse(sourceQuery.getControlConfiguration().getSchema()), this.controlUsernameOverride.orElse(sourceQuery.getControlConfiguration().getUsername()), Optional.ofNullable(this.controlPasswordOverride.orElse(sourceQuery.getControlConfiguration().getPassword().orElse(null))), sourceQuery.getControlConfiguration().getSessionProperties()))).collect(ImmutableList.toImmutableList());
    }

    private List<SourceQuery> applyWhitelist(List<SourceQuery> sourceQueries) {
        if (!this.whitelist.isPresent()) {
            return sourceQueries;
        }
        List selected = (List)sourceQueries.stream().filter(sourceQuery -> this.whitelist.get().contains(sourceQuery.getName())).collect(ImmutableList.toImmutableList());
        log.info("Applying whitelist... Remaining queries: %s", new Object[]{selected.size()});
        return selected;
    }

    private List<SourceQuery> applyBlacklist(List<SourceQuery> sourceQueries) {
        if (!this.blacklist.isPresent()) {
            return sourceQueries;
        }
        List selected = (List)sourceQueries.stream().filter(sourceQuery -> !this.blacklist.get().contains(sourceQuery.getName())).collect(ImmutableList.toImmutableList());
        log.info("Applying blacklist... Remaining queries: %s", new Object[]{selected.size()});
        return selected;
    }

    private List<SourceQuery> filterQueryType(List<SourceQuery> sourceQueries) {
        ImmutableList.Builder selected = ImmutableList.builder();
        for (SourceQuery sourceQuery : sourceQueries) {
            try {
                QueryType testQueryType;
                QueryType controlQueryType = QueryType.of(this.sqlParser.createStatement(sourceQuery.getControlQuery(), VerifierUtil.PARSING_OPTIONS));
                if (controlQueryType != (testQueryType = QueryType.of(this.sqlParser.createStatement(sourceQuery.getTestQuery(), VerifierUtil.PARSING_OPTIONS))) || controlQueryType.getCategory() != QueryType.Category.DATA_PRODUCING) continue;
                selected.add((Object)sourceQuery);
            }
            catch (ParsingException e) {
                log.warn("Failed to parse query: %s", new Object[]{sourceQuery.getName()});
            }
            catch (UnsupportedQueryTypeException unsupportedQueryTypeException) {}
        }
        ImmutableList selectQueries = selected.build();
        log.info("Filtering query type... Remaining queries: %s", new Object[]{selectQueries.size()});
        return selectQueries;
    }

    private List<SourceQuery> applyCustomFilters(List<SourceQuery> sourceQueries) {
        if (this.customQueryFilters.isEmpty()) {
            return sourceQueries;
        }
        log.info("Applying custom query filters");
        for (Predicate<SourceQuery> filter : this.customQueryFilters) {
            sourceQueries = (List)sourceQueries.stream().filter(filter::test).collect(ImmutableList.toImmutableList());
            log.info("Applying custom filter %s... Remaining queries: %s", new Object[]{filter.getClass().getSimpleName(), sourceQueries.size()});
        }
        return sourceQueries;
    }

    private CompletionService<Optional<VerifierQueryEvent>> submitSourceQueriesForVerification(List<SourceQuery> sourceQueries) {
        ExecutorService executor = Executors.newFixedThreadPool(this.maxConcurrency);
        ExecutorCompletionService<Optional<VerifierQueryEvent>> completionService = new ExecutorCompletionService<Optional<VerifierQueryEvent>>(executor);
        for (int i = 0; i < this.suiteRepetitions; ++i) {
            for (SourceQuery sourceQuery : sourceQueries) {
                for (int j = 0; j < this.queryRepetitions; ++j) {
                    Verification verification = this.verificationFactory.get(sourceQuery);
                    completionService.submit(verification::run);
                }
            }
        }
        executor.shutdown();
        return completionService;
    }

    private void reportProgressUntilFinished(CompletionService<Optional<VerifierQueryEvent>> completionService, int queriesSubmitted) {
        int completed = 0;
        double lastProgress = 0.0;
        EnumMap<VerifierQueryEvent.EventStatus, Integer> statusCount = new EnumMap<VerifierQueryEvent.EventStatus, Integer>(VerifierQueryEvent.EventStatus.class);
        while (completed < queriesSubmitted) {
            try {
                double progress;
                Optional<VerifierQueryEvent> event = completionService.take().get();
                ++completed;
                if (!event.isPresent()) {
                    statusCount.compute(VerifierQueryEvent.EventStatus.SKIPPED, (status, count) -> count == null ? 1 : count + 1);
                } else {
                    statusCount.compute(VerifierQueryEvent.EventStatus.valueOf(event.get().getStatus()), (status, count) -> count == null ? 1 : count + 1);
                    for (EventClient eventClient : this.eventClients) {
                        eventClient.post((Object[])new VerifierQueryEvent[]{event.get()});
                    }
                }
                if (!((progress = (double)completed / (double)queriesSubmitted * 100.0) - lastProgress > 0.5) && completed != queriesSubmitted) continue;
                log.info("Progress: %s succeeded, %s skipped, %s resolved, %s failed, %.2f%% done", new Object[]{statusCount.getOrDefault((Object)VerifierQueryEvent.EventStatus.SUCCEEDED, 0), statusCount.getOrDefault((Object)VerifierQueryEvent.EventStatus.SKIPPED, 0), statusCount.getOrDefault((Object)VerifierQueryEvent.EventStatus.FAILED_RESOLVED, 0), statusCount.getOrDefault((Object)VerifierQueryEvent.EventStatus.FAILED, 0), progress});
                lastProgress = progress;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

